/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.synchronizefx.netty.base.client;

import de.saxsys.synchronizefx.core.clientserver.NetworkToTopologyCallbackClient;
import de.saxsys.synchronizefx.core.exceptions.SynchronizeFXException;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NetworkEventHandlerClient
extends ChannelDuplexHandler {
    private static final Logger LOG = LoggerFactory.getLogger(NetworkEventHandlerClient.class);
    private final NetworkToTopologyCallbackClient callback;
    private boolean clientInitiatedClose;

    public NetworkEventHandlerClient(NetworkToTopologyCallbackClient callback) {
        this.callback = callback;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        LOG.info("Connected to the server.");
        ctx.fireChannelActive();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (!this.clientInitiatedClose) {
            this.callback.onServerDisconnect();
        }
        LOG.info("Connection to the server is closed now.");
        ctx.fireChannelInactive();
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise future) throws Exception {
        this.clientInitiatedClose = true;
        ctx.close(future);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        ctx.channel().close();
        SynchronizeFXException exception = cause instanceof SynchronizeFXException ? (SynchronizeFXException)cause : new SynchronizeFXException("An error occured while trying to communicate with the server.", cause);
        this.callback.onError(exception);
    }

    public void write(final ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        promise.addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(){

            public void operationComplete(Future<? super Void> future) throws Exception {
                Throwable cause = future.cause();
                if (cause != null) {
                    NetworkEventHandlerClient.this.exceptionCaught(ctx, cause);
                }
            }
        });
        ctx.write(msg, promise);
    }
}

