/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.synchronizefx.netty.base.client;

import de.saxsys.synchronizefx.core.clientserver.CommandTransferClient;
import de.saxsys.synchronizefx.core.clientserver.NetworkToTopologyCallbackClient;
import de.saxsys.synchronizefx.core.exceptions.SynchronizeFXException;
import de.saxsys.synchronizefx.core.metamodel.commands.Command;
import de.saxsys.synchronizefx.netty.base.client.BasicChannelInitializerClient;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.net.SocketAddress;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NettyBasicClient
implements CommandTransferClient {
    private static final Logger LOG = LoggerFactory.getLogger(NettyBasicClient.class);
    private static final int TIMEOUT = 10000;
    private final SocketAddress address;
    private NetworkToTopologyCallbackClient callback;
    private EventLoopGroup eventLoopGroup;
    private Channel channel;

    public NettyBasicClient(SocketAddress address) {
        this.address = address;
    }

    protected abstract BasicChannelInitializerClient createChannelInitializer();

    public void setTopologyCallback(NetworkToTopologyCallbackClient callback) {
        this.callback = callback;
    }

    public void connect() throws SynchronizeFXException {
        this.eventLoopGroup = new NioEventLoopGroup();
        BasicChannelInitializerClient channelInitializer = this.createChannelInitializer();
        channelInitializer.setTopologyCallback(this.callback);
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(this.eventLoopGroup)).channel(NioSocketChannel.class)).option(ChannelOption.ALLOCATOR, (Object)UnpooledByteBufAllocator.DEFAULT)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)10000)).handler((ChannelHandler)channelInitializer);
        LOG.info("Connecting to server");
        try {
            ChannelFuture future = bootstrap.connect(this.address);
            if (!future.await(10000L)) {
                this.disconnect();
                throw new SynchronizeFXException("Timeout while trying to connect to the server.");
            }
            if (!future.isSuccess()) {
                this.disconnect();
                throw new SynchronizeFXException("Connection to the server failed.", future.cause());
            }
            this.channel = future.channel();
        }
        catch (InterruptedException e) {
            this.disconnect();
            throw new SynchronizeFXException((Throwable)e);
        }
    }

    public void send(List<Command> commands) {
        this.channel.writeAndFlush(commands);
    }

    public void disconnect() {
        try {
            if (this.channel != null) {
                this.channel.close();
                this.channel.closeFuture().sync();
            }
        }
        catch (InterruptedException e) {
            this.callback.onError(new SynchronizeFXException("Could not wait for the disconnect to finish.", (Throwable)e));
        }
        this.eventLoopGroup.shutdownGracefully();
    }
}

