/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.synchronizefx.netty.base.client;

import de.saxsys.synchronizefx.core.clientserver.NetworkToTopologyCallbackClient;
import de.saxsys.synchronizefx.core.clientserver.Serializer;
import de.saxsys.synchronizefx.netty.base.Codec;
import de.saxsys.synchronizefx.netty.base.CommandToBinaryByteBuf;
import de.saxsys.synchronizefx.netty.base.NonValidatingSSLEngineFactory;
import de.saxsys.synchronizefx.netty.base.client.InboundCommandHandlerClient;
import de.saxsys.synchronizefx.netty.base.client.NetworkEventHandlerClient;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.concurrent.TimeUnit;

public class BasicChannelInitializerClient
extends ChannelInitializer<SocketChannel> {
    private static final int KEEP_ALIVE = 20000;
    private NetworkToTopologyCallbackClient callback;
    private final Codec codec;
    private final boolean useSSL;
    private final Serializer serializer;

    public BasicChannelInitializerClient(Serializer serializer, Codec codec, boolean useSSL) {
        this.codec = codec;
        this.useSSL = useSSL;
        this.serializer = serializer;
    }

    void setTopologyCallback(NetworkToTopologyCallbackClient callback) {
        this.callback = callback;
    }

    protected void initChannel(SocketChannel channel) throws Exception {
        ChannelPipeline pipeline = channel.pipeline();
        if (this.useSSL) {
            pipeline.addLast("tls", (ChannelHandler)NonValidatingSSLEngineFactory.createSslHandler(true));
        }
        pipeline.addLast("keep-alive", (ChannelHandler)new IdleStateHandler(20000L, 0L, 0L, TimeUnit.MILLISECONDS));
        this.codec.addToPipeline(pipeline);
        pipeline.addLast("message-to-command", (ChannelHandler)new CommandToBinaryByteBuf(this.serializer));
        pipeline.addLast("command-handler", (ChannelHandler)new InboundCommandHandlerClient(this.callback));
        pipeline.addLast("event-handler", (ChannelHandler)new NetworkEventHandlerClient(this.callback));
    }
}

