/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.synchronizefx.netty.base;

import de.saxsys.synchronizefx.core.exceptions.SynchronizeFXException;
import io.netty.channel.Channel;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NonValidatingSSLEngineFactory {
    private static final Logger LOG = LoggerFactory.getLogger(NonValidatingSSLEngineFactory.class);
    private static SSLContext context;

    private NonValidatingSSLEngineFactory() {
    }

    public static SslHandler createSslHandler(boolean clientMode) {
        final SSLEngine engine = NonValidatingSSLEngineFactory.createEngine(clientMode);
        SslHandler handler = new SslHandler(engine);
        handler.handshakeFuture().addListener((GenericFutureListener)new GenericFutureListener<Future<? super Channel>>(){

            public void operationComplete(Future<? super Channel> future) throws Exception {
                LOG.debug("Using cipher " + engine.getSession().getCipherSuite() + " for the encrypted connection to the server.");
            }
        });
        return handler;
    }

    public static SSLEngine createEngine(boolean clientMode) {
        if (context == null) {
            context = NonValidatingSSLEngineFactory.createContext();
        }
        SSLEngine engine = context.createSSLEngine();
        engine.setUseClientMode(clientMode);
        return engine;
    }

    private static SSLContext createContext() throws SynchronizeFXException {
        try {
            SSLContext context = SSLContext.getInstance("TLSv1.2");
            context.init(null, new TrustManager[]{new NonValidatingTrustManager()}, null);
            return context;
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new SynchronizeFXException("Could not initialize the encryption for the encrypted web socket connection to the server.", (Throwable)e);
        }
    }

    private static final class NonValidatingTrustManager
    implements X509TrustManager {
        private NonValidatingTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }
    }
}

