/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.synchronizefx.netty.base;

import de.saxsys.synchronizefx.core.clientserver.Serializer;
import de.saxsys.synchronizefx.core.metamodel.commands.Command;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import java.util.List;

public class CommandToBinaryByteBuf
extends MessageToMessageCodec<ByteBuf, List<Command>> {
    private final Serializer serializer;

    public CommandToBinaryByteBuf(Serializer serializer) {
        this.serializer = serializer;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) throws Exception {
        byte[] data;
        if (msg.hasArray()) {
            data = msg.array();
        } else {
            data = new byte[msg.readableBytes()];
            msg.readBytes(data);
        }
        out.add(this.serializer.deserialize(data));
    }

    protected void encode(ChannelHandlerContext ctx, List<Command> msg, List<Object> out) throws Exception {
        ByteBuf buffer = Unpooled.wrappedBuffer((byte[])this.serializer.serialize(msg));
        buffer.retain();
        out.add(buffer);
    }
}

