/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.synchronizefx.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import de.saxsys.synchronizefx.core.metamodel.commands.AddToList;
import de.saxsys.synchronizefx.core.metamodel.commands.RemoveFromList;
import de.saxsys.synchronizefx.core.metamodel.commands.ReplaceInList;
import de.saxsys.synchronizefx.core.metamodel.commands.SetPropertyValue;
import de.saxsys.synchronizefx.core.metamodel.commands.Value;
import de.saxsys.synchronizefx.kryo.serializer.AddToListSerializer;
import de.saxsys.synchronizefx.kryo.serializer.RemoveFromListSerializer;
import de.saxsys.synchronizefx.kryo.serializer.ReplaceInListSerializer;
import de.saxsys.synchronizefx.kryo.serializer.SetPropertyValueSerializer;
import de.saxsys.synchronizefx.kryo.serializer.UUIDSerializer;
import de.saxsys.synchronizefx.kryo.serializer.ValueSerializer;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;

final class KryoInitializer
extends ThreadLocal<Kryo> {
    private List<CustomSerializers<?>> customSerializers = new LinkedList();

    KryoInitializer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Kryo initialValue() {
        Kryo kryo = new Kryo();
        kryo.register(UUID.class, (Serializer)new UUIDSerializer());
        kryo.register(Value.class, (Serializer)new ValueSerializer());
        kryo.register(SetPropertyValue.class, (Serializer)new SetPropertyValueSerializer());
        kryo.register(AddToList.class, (Serializer)new AddToListSerializer());
        kryo.register(RemoveFromList.class, (Serializer)new RemoveFromListSerializer());
        kryo.register(ReplaceInList.class, (Serializer)new ReplaceInListSerializer());
        List<CustomSerializers<?>> list = this.customSerializers;
        synchronized (list) {
            for (CustomSerializers<?> serializer : this.customSerializers) {
                if (((CustomSerializers)serializer).serializer != null) {
                    kryo.register(((CustomSerializers)serializer).clazz, ((CustomSerializers)serializer).serializer);
                    continue;
                }
                kryo.register(((CustomSerializers)serializer).clazz);
            }
        }
        return kryo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> void registerSerializableClass(Class<T> clazz, Serializer<T> serializer) {
        List<CustomSerializers<?>> list = this.customSerializers;
        synchronized (list) {
            this.customSerializers.add(new CustomSerializers<T>(clazz, serializer));
        }
    }

    private static class CustomSerializers<T> {
        private final Class<T> clazz;
        private final Serializer<T> serializer;

        public CustomSerializers(Class<T> clazz, Serializer<T> serializer) {
            this.clazz = clazz;
            this.serializer = serializer;
        }
    }
}

