/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.xml.core;

import de.saxsys.svgfx.xml.core.AttributeHolder;
import de.saxsys.svgfx.xml.core.AttributeWrapper;
import de.saxsys.svgfx.xml.core.IDocumentDataProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class ElementBase<TAttributeType extends AttributeWrapper, TAttributeHolder extends AttributeHolder<TAttributeType>, TDocumentDataProvider extends IDocumentDataProvider, TResult, TChild extends ElementBase<?, ?, TDocumentDataProvider, ?, ?>> {
    private final String name;
    private final List<TChild> children;
    private final TDocumentDataProvider documentDataProvider;
    private final TAttributeHolder attributeHolder;

    public ElementBase(String name, Attributes attributes, TDocumentDataProvider documentDataProvider, TAttributeHolder attributeHolder) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Creation of element %s failed. Given name must not be null", this.getClass().getName()));
        }
        if (documentDataProvider == null) {
            throw new IllegalArgumentException(String.format("Creation of element %s failed. given data provider must not be null", this.getClass().getName()));
        }
        if (attributeHolder == null) {
            throw new IllegalArgumentException(String.format("Creation of element %s failed. given attributeHolder must not be null", this.getClass().getName()));
        }
        this.name = name;
        this.attributeHolder = attributeHolder;
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attributeName = attributes.getQName(i);
                Object contentType = ((AttributeHolder)this.attributeHolder).createAttributeType(attributeName);
                String attributeValue = attributes.getValue(i);
                if (contentType == null) continue;
                try {
                    ((AttributeWrapper)contentType).setText(attributeValue);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(String.format("Creation of element [%s] failed. The attribute [%s] is not valid, value is [%s]", this.getClass().getName(), attributeName, attributeValue), e);
                }
                ((AttributeHolder)this.attributeHolder).getAttributes().put(attributeName, contentType);
            }
        }
        this.children = new ArrayList<TChild>();
        this.documentDataProvider = documentDataProvider;
    }

    public String getName() {
        return this.name;
    }

    public final Map<String, TAttributeType> getAttributes() {
        return Collections.unmodifiableMap(((AttributeHolder)this.attributeHolder).getAttributes());
    }

    public TDocumentDataProvider getDocumentDataProvider() {
        return this.documentDataProvider;
    }

    public TAttributeHolder getAttributeHolder() {
        return this.attributeHolder;
    }

    public List<TChild> getUnmodifiableChildren() {
        return Collections.unmodifiableList(this.children);
    }

    boolean addChild(TChild child) {
        return this.children.add(child);
    }

    public abstract boolean keepElement();

    public abstract void startProcessing() throws SAXException;

    public abstract void processCharacterData(char[] var1, int var2, int var3) throws SAXException;

    public abstract void endProcessing() throws SAXException;

    public abstract TResult getResult() throws SAXException;

    public String toString() {
        StringBuilder data = new StringBuilder();
        data.append("<").append(this.name);
        ((AttributeHolder)this.attributeHolder).getAttributes().forEach((key, value) -> data.append(String.format(" %s:%s", key, value)));
        data.append(">");
        return data.toString();
    }
}

