/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.xml.core;

import de.saxsys.svgfx.core.SVGException;
import de.saxsys.svgfx.xml.core.AttributeWrapper;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public abstract class AttributeHolder<TAttribute extends AttributeWrapper> {
    private final Map<String, TAttribute> attributes = new HashMap<String, TAttribute>();

    public abstract TAttribute createAttributeType(String var1);

    public final Map<String, TAttribute> getAttributes() {
        return this.attributes;
    }

    public final Optional<TAttribute> getAttribute(String name) {
        return Optional.ofNullable(this.attributes.get(name));
    }

    public final <TContent extends TAttribute> Optional<TContent> getAttribute(String name, Class<TContent> clazz) {
        return Optional.ofNullable(clazz.cast(this.attributes.get(name)));
    }

    public final <TContent extends TAttribute> TContent getAttributeOrFail(String name, Class<TContent> clazz) throws SVGException {
        AttributeWrapper attribute = (AttributeWrapper)clazz.cast(this.attributes.get(name));
        if (attribute == null) {
            throw new SVGException(String.format("Could not find desired attribute [%s]", name));
        }
        return (TContent)attribute;
    }
}

