/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.css.core;

import de.saxsys.svgfx.core.utils.StringUtil;
import de.saxsys.svgfx.xml.core.AttributeHolder;
import de.saxsys.svgfx.xml.core.AttributeWrapper;
import java.util.Map;
import javafx.util.Pair;

public abstract class CssStyle<TAttributeType extends AttributeWrapper, TAttributeHolder extends AttributeHolder<TAttributeType>> {
    private Selector selector;
    private String name;
    private final TAttributeHolder attributeHolder;

    public CssStyle(TAttributeHolder attributeHolder) {
        this.attributeHolder = attributeHolder;
    }

    public CssStyle(String name, TAttributeHolder attributeHolder) {
        this.name = name;
        this.attributeHolder = attributeHolder;
    }

    public final String getName() {
        return this.name;
    }

    public final TAttributeHolder getAttributeHolder() {
        return this.attributeHolder;
    }

    public final Map<String, TAttributeType> getProperties() {
        return ((AttributeHolder)this.attributeHolder).getAttributes();
    }

    private void setNameAndSelector(String name) {
        if (StringUtil.isNotNullOrEmpty(name)) {
            if (name.startsWith(Selector.ID.getName())) {
                this.selector = Selector.ID;
                this.name = name.replace(Selector.ID.getName(), "");
            } else if (name.startsWith(Selector.CLASS.getName())) {
                this.selector = Selector.CLASS;
                this.name = name.replace(Selector.CLASS.getName(), "");
            } else {
                this.selector = Selector.NONE;
                this.name = name;
            }
        } else {
            this.name = name;
        }
    }

    private Pair<String, TAttributeType> determineAttributeType(String data) throws IllegalArgumentException {
        if (StringUtil.isNullOrEmpty(data)) {
            throw new IllegalArgumentException("Given data must not be null in order to create a attribute type from it");
        }
        String trimmedData = data.trim();
        int index = trimmedData.indexOf(58);
        if (index == -1 || index >= trimmedData.length() - 1) {
            throw new IllegalArgumentException("Given data either does not provide a attribute type separator separator or is to short");
        }
        String name = trimmedData.substring(0, index).trim();
        Object attribute = ((AttributeHolder)this.attributeHolder).createAttributeType(StringUtil.stripStringIndicators(name));
        if (attribute != null) {
            ((AttributeWrapper)attribute).setText(StringUtil.stripStringIndicators(trimmedData.substring(index + 1).trim()));
        }
        return new Pair((Object)name, attribute);
    }

    public final void combineWithStyle(CssStyle<TAttributeType, TAttributeHolder> style) {
        if (style == null) {
            throw new IllegalArgumentException("given style must not be null");
        }
        if (this == style) {
            return;
        }
        for (Map.Entry entry : ((AttributeHolder)style.attributeHolder).getAttributes().entrySet()) {
            if (((AttributeHolder)this.attributeHolder).getAttributes().containsKey(entry.getKey())) continue;
            ((AttributeHolder)this.attributeHolder).getAttributes().put(entry.getKey(), entry.getValue());
        }
    }

    public final void parseCssText(String cssText) {
        this.name = null;
        this.selector = Selector.NONE;
        ((AttributeHolder)this.attributeHolder).getAttributes().clear();
        StringBuilder dataBuilder = new StringBuilder();
        boolean isInsideDeclarationBlock = false;
        ParsingState state = ParsingState.DATA;
        for (int i = 0; i < cssText.length(); ++i) {
            char character = cssText.charAt(i);
            if (state == ParsingState.COMMENT) {
                if (character != '/' || i <= 0 || cssText.charAt(i - 1) != '*') continue;
                state = ParsingState.DATA;
                continue;
            }
            if (character == '\"') {
                state = state != ParsingState.STRING ? ParsingState.STRING : ParsingState.DATA;
            }
            if (state != ParsingState.STRING) {
                Pair<String, TAttributeType> property;
                if (character == '/' && i < cssText.length() - 1 && cssText.charAt(i + 1) == '*') {
                    state = ParsingState.COMMENT;
                    continue;
                }
                if (character == '{') {
                    this.setNameAndSelector(dataBuilder.toString().trim());
                    isInsideDeclarationBlock = true;
                    dataBuilder.setLength(0);
                    continue;
                }
                if (character == ';') {
                    property = this.determineAttributeType(dataBuilder.toString());
                    if (property.getValue() != null) {
                        ((AttributeHolder)this.attributeHolder).getAttributes().put((String)property.getKey(), property.getValue());
                    }
                    dataBuilder.setLength(0);
                    continue;
                }
                if (character == '}') {
                    if (dataBuilder.toString().trim().length() > 0 && (property = this.determineAttributeType(dataBuilder.toString())).getValue() != null) {
                        ((AttributeHolder)this.attributeHolder).getAttributes().put((String)property.getKey(), property.getValue());
                    }
                    isInsideDeclarationBlock = false;
                    break;
                }
                dataBuilder.append(character);
                continue;
            }
            if (!isInsideDeclarationBlock) continue;
            dataBuilder.append(character);
        }
        if (isInsideDeclarationBlock) {
            throw new IllegalStateException("Css text not properly closed, can not use this css data.");
        }
    }

    public int hashCode() {
        return this.name == null ? super.hashCode() : this.name.hashCode();
    }

    public boolean equals(Object obj) {
        boolean result = super.equals(obj);
        if (!result && obj != null && CssStyle.class.isAssignableFrom(obj.getClass())) {
            CssStyle other = (CssStyle)obj;
            result = this.name == null ? other.getName() == null : this.name.equals(other.getName());
        }
        return result;
    }

    private static enum Selector {
        NONE("."),
        CLASS("."),
        ID("#");

        private final String name;

        private Selector(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    private static enum ParsingState {
        DATA,
        COMMENT,
        STRING;

    }
}

