/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.core.utils;

import de.saxsys.svgfx.core.interfaces.ThrowableBiConsumer;
import de.saxsys.svgfx.core.interfaces.ThrowablePredicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class StringUtil {
    private StringUtil() {
    }

    public static String replaceLast(String source, char toReplace, char toUse) {
        return StringUtil.replaceLast(source, String.valueOf(toReplace), String.valueOf(toUse));
    }

    public static String replaceLast(String source, String toReplace, String toUse) {
        if (source == null) {
            return null;
        }
        int lastIndex = source.lastIndexOf(toReplace);
        if (lastIndex < 0) {
            return source;
        }
        return String.format("%s%s", source.substring(0, lastIndex), source.substring(lastIndex).replaceFirst(toReplace, toUse));
    }

    public static boolean isNullOrEmpty(String data) {
        return data == null || data.isEmpty();
    }

    public static boolean isNotNullOrEmpty(String data) {
        return !StringUtil.isNullOrEmpty(data);
    }

    public static boolean isNullOrEmptyAfterTrim(String data) {
        return StringUtil.isNullOrEmpty(data) || StringUtil.isNullOrEmpty(data.trim());
    }

    public static boolean isNotNullOrEmptyAfterTrim(String data) {
        return !StringUtil.isNullOrEmptyAfterTrim(data);
    }

    public static String stripStringIndicators(String data) {
        if (StringUtil.isNullOrEmpty(data)) {
            throw new IllegalArgumentException("given data must not be null or empty");
        }
        return data.substring(data.charAt(0) == '\"' ? 1 : 0, data.charAt(data.length() - 1) == '\"' ? data.length() - 1 : data.length());
    }

    public static <E extends Exception> List<String> splitByDelimiters(String data, Collection<Character> delimiters, ThrowablePredicate<String, E> consumePredicate) throws E {
        ArrayList<String> result = new ArrayList<String>();
        StringUtil.splitByDelimiters(data, delimiters, (Character delimiter, String split) -> {
            if (consumePredicate.testOrFail((String)split)) {
                result.add((String)split);
            }
        });
        return result;
    }

    public static <E extends Exception> void splitByDelimiters(String data, Collection<Character> delimiters, ThrowableBiConsumer<Character, String, E> splitConsumer) throws E {
        StringBuilder builder = new StringBuilder();
        Character lastFoundDelimiter = null;
        for (int i = 0; i < data.length(); ++i) {
            boolean isLastCharacter;
            char character = data.charAt(i);
            boolean isDelimiter = delimiters.contains(Character.valueOf(character));
            boolean bl = isLastCharacter = i == data.length() - 1;
            if (isLastCharacter || isDelimiter) {
                if (isLastCharacter && !isDelimiter) {
                    builder.append(character);
                }
                if (lastFoundDelimiter != null || builder.length() > 0) {
                    splitConsumer.acceptOrFail(lastFoundDelimiter, builder.toString());
                }
                lastFoundDelimiter = null;
                builder.setLength(0);
                if (!isDelimiter) continue;
                lastFoundDelimiter = Character.valueOf(character);
                continue;
            }
            builder.append(character);
        }
        if (lastFoundDelimiter != null) {
            splitConsumer.acceptOrFail(lastFoundDelimiter, null);
        }
    }
}

