/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.core.utils;

import de.saxsys.svgfx.core.SVGDocumentDataProvider;
import de.saxsys.svgfx.core.SVGException;
import de.saxsys.svgfx.core.elements.SVGElementBase;
import de.saxsys.svgfx.core.utils.StringUtil;

public final class SVGUtil {
    private SVGUtil() {
    }

    public static String stripIRIIdentifiers(String data) {
        if (StringUtil.isNullOrEmpty(data)) {
            throw new IllegalArgumentException("given data must not be null or empty");
        }
        int dataLengthReduction = 1;
        int identifierLength = "url(#".length();
        int index = -1;
        if (data.length() > "url(#".length() && data.startsWith("url(#")) {
            index = "url(#".length();
        }
        if (index == -1) {
            dataLengthReduction = 0;
            identifierLength = "#".length();
            if (data.length() > "#".length() && data.startsWith("#")) {
                index = "#".length();
            }
        }
        if (index > -1) {
            return data.substring(identifierLength, data.length() - dataLengthReduction);
        }
        return null;
    }

    public static <TSVGElementBase extends SVGElementBase<?>> TSVGElementBase resolveIRI(String data, SVGDocumentDataProvider dataProvider, Class<TSVGElementBase> clazz) throws SVGException {
        String reference = SVGUtil.stripIRIIdentifiers(data);
        if (StringUtil.isNullOrEmpty(reference)) {
            throw new IllegalArgumentException(String.format("Given data [%s] appears to not be a IRI reference.", data));
        }
        return (TSVGElementBase)((SVGElementBase)dataProvider.getData(reference, clazz).orElseThrow(() -> new SVGException(String.format("Given reference [%s] could not be resolved", data))));
    }
}

