/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.core.path.commands;

import de.saxsys.svgfx.core.path.PathException;
import de.saxsys.svgfx.core.path.commands.PathCommand;
import java.util.Optional;
import javafx.geometry.Point2D;
import javafx.scene.shape.Rectangle;

public class VerticalLineCommand
extends PathCommand {
    private final double distance;

    VerticalLineCommand(boolean isAbsolute, double distance) {
        super(isAbsolute);
        this.distance = distance;
    }

    @Override
    public Point2D getAbsoluteEndPoint(Point2D absoluteCurrentPoint) throws PathException {
        if (absoluteCurrentPoint == null) {
            throw new PathException("May not create a new position when there is no position to relate to");
        }
        if (this.isAbsolute()) {
            return new Point2D(absoluteCurrentPoint.getX(), this.distance);
        }
        return new Point2D(absoluteCurrentPoint.getX(), absoluteCurrentPoint.getY() + this.distance);
    }

    @Override
    public Optional<Rectangle> getBoundingBox(Point2D absoluteCurrentPoint) throws PathException {
        Point2D nextPosition = this.getAbsoluteEndPoint(absoluteCurrentPoint);
        return Optional.of(new Rectangle(absoluteCurrentPoint.getX(), this.getMinY(absoluteCurrentPoint, nextPosition), 0.0, this.isAbsolute() ? this.getDistanceY(nextPosition, absoluteCurrentPoint) : Math.abs(this.distance)));
    }
}

