/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.core.path.commands;

import de.saxsys.svgfx.core.path.PathException;
import de.saxsys.svgfx.core.path.commands.BezierCurveCommand;
import javafx.geometry.Point2D;

public class QuadraticBezierCurveCommand
extends BezierCurveCommand {
    private static final double TWO_THIRD = 0.6666666666666666;
    private final Point2D controlPoint;

    QuadraticBezierCurveCommand(boolean isAbsolute, Point2D controlPoint, Point2D endPoint) {
        super(isAbsolute, endPoint);
        this.controlPoint = controlPoint;
    }

    public Point2D getAbsoluteControlPoint(Point2D absoluteCurrentPoint) throws PathException {
        return this.addPoints(absoluteCurrentPoint, this.controlPoint);
    }

    @Override
    public Point2D getAbsoluteStartControlPoint(Point2D absoluteCurrentPoint) throws PathException {
        if (absoluteCurrentPoint == null) {
            throw new PathException("Can not get absolute start control point when current point is missing");
        }
        Point2D distance = this.isAbsolute() ? new Point2D(0.6666666666666666 * (this.controlPoint.getX() - absoluteCurrentPoint.getX()), 0.6666666666666666 * (this.controlPoint.getY() - absoluteCurrentPoint.getY())) : this.controlPoint.multiply(0.6666666666666666);
        return absoluteCurrentPoint.add(distance);
    }

    @Override
    public Point2D getAbsoluteEndControlPoint(Point2D absoluteCurrentPoint) throws PathException {
        Point2D absoluteEndPoint = this.getAbsoluteEndPoint(absoluteCurrentPoint);
        Point2D absoluteControlPoint = this.isAbsolute() ? this.controlPoint : absoluteCurrentPoint.add(this.controlPoint);
        Point2D distance = new Point2D(0.6666666666666666 * (absoluteControlPoint.getX() - absoluteEndPoint.getX()), 0.6666666666666666 * (absoluteControlPoint.getY() - absoluteEndPoint.getY()));
        return absoluteEndPoint.add(distance);
    }
}

