/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.core.path.commands;

import de.saxsys.svgfx.core.path.PathException;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import javafx.geometry.Point2D;
import javafx.scene.shape.Rectangle;

public abstract class PathCommand {
    private final boolean isAbsolute;

    protected PathCommand(boolean isAbsolute) {
        this.isAbsolute = isAbsolute;
    }

    public boolean isAbsolute() {
        return this.isAbsolute;
    }

    public abstract Point2D getAbsoluteEndPoint(Point2D var1) throws PathException;

    public abstract Optional<Rectangle> getBoundingBox(Point2D var1) throws PathException;

    protected Point2D addPoints(Point2D first, Point2D second) throws PathException {
        if (this.isAbsolute()) {
            return second;
        }
        if (first == null) {
            throw new PathException("Position of a relative command can not be determined if the position is not provided");
        }
        return first.add(second);
    }

    protected double getDistanceX(Point2D first, Point2D second) throws PathException {
        return this.getValueOrFail(first, second, value -> 0.0, (firstValue, secondValue) -> Math.abs(firstValue.getX() - secondValue.getX()));
    }

    protected double getMinX(Point2D first, Point2D second) throws PathException {
        return this.getValueOrFail(first, second, Point2D::getX, (firstP, secondP) -> Math.min(firstP.getX(), secondP.getX()));
    }

    protected double getDistanceY(Point2D first, Point2D second) throws PathException {
        return this.getValueOrFail(first, second, value -> 0.0, (firstValue, secondValue) -> Math.abs(firstValue.getY() - secondValue.getY()));
    }

    protected double getMinY(Point2D first, Point2D second) throws PathException {
        return this.getValueOrFail(first, second, Point2D::getY, (firstP, secondP) -> Math.min(firstP.getY(), secondP.getY()));
    }

    protected <T, R> R getValueOrFail(T first, T second, Function<T, R> valueProvider, BiFunction<T, T, R> resolver) throws PathException {
        if (first == null) {
            if (second == null) {
                throw new PathException("May not determine desired value if both arguments are null");
            }
            return valueProvider.apply(second);
        }
        if (second == null) {
            return valueProvider.apply(first);
        }
        return resolver.apply(first, second);
    }
}

