/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.core.path.commands;

import de.saxsys.svgfx.core.path.PathException;
import de.saxsys.svgfx.core.path.commands.PathCommand;
import java.util.Optional;
import javafx.geometry.Point2D;
import javafx.scene.shape.Rectangle;

public class LineCommand
extends PathCommand {
    protected final Point2D endPoint;

    LineCommand(boolean isAbsolute, Point2D endPoint) {
        super(isAbsolute);
        this.endPoint = endPoint;
    }

    public Point2D getEndPoint() {
        return this.endPoint;
    }

    @Override
    public Point2D getAbsoluteEndPoint(Point2D absoluteCurrentPoint) throws PathException {
        return this.addPoints(absoluteCurrentPoint, this.endPoint);
    }

    @Override
    public Optional<Rectangle> getBoundingBox(Point2D absoluteCurrentPoint) throws PathException {
        Point2D nextPosition = this.getAbsoluteEndPoint(absoluteCurrentPoint);
        return Optional.of(new Rectangle(this.getMinX(absoluteCurrentPoint, nextPosition), this.getMinY(absoluteCurrentPoint, nextPosition), this.isAbsolute() ? this.getDistanceX(nextPosition, absoluteCurrentPoint) : Math.abs(this.endPoint.getX()), this.isAbsolute() ? this.getDistanceY(nextPosition, absoluteCurrentPoint) : Math.abs(this.endPoint.getY())));
    }
}

