/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.core.path.commands;

import de.saxsys.svgfx.core.path.PathException;
import de.saxsys.svgfx.core.path.commands.PathCommand;
import java.util.Optional;
import javafx.geometry.Point2D;
import javafx.scene.shape.Rectangle;

public class HorizontalLineCommand
extends PathCommand {
    private final double distance;

    HorizontalLineCommand(boolean isAbsolute, double distance) {
        super(isAbsolute);
        this.distance = distance;
    }

    @Override
    public Point2D getAbsoluteEndPoint(Point2D absoluteCurrentPoint) throws PathException {
        if (absoluteCurrentPoint == null) {
            throw new PathException("May not create a new position when there is no position to relate to");
        }
        if (this.isAbsolute()) {
            return new Point2D(this.distance, absoluteCurrentPoint.getY());
        }
        return new Point2D(absoluteCurrentPoint.getX() + this.distance, absoluteCurrentPoint.getY());
    }

    @Override
    public Optional<Rectangle> getBoundingBox(Point2D absoluteCurrentPoint) throws PathException {
        Point2D nextPosition = this.getAbsoluteEndPoint(absoluteCurrentPoint);
        return Optional.of(new Rectangle(this.getMinX(absoluteCurrentPoint, nextPosition), absoluteCurrentPoint.getY(), this.isAbsolute() ? this.getDistanceX(nextPosition, absoluteCurrentPoint) : Math.abs(this.distance), 0.0));
    }
}

