/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.core.path.commands;

import de.saxsys.svgfx.core.definitions.Constants;
import de.saxsys.svgfx.core.interfaces.ThrowableBiFunction;
import de.saxsys.svgfx.core.path.CommandName;
import de.saxsys.svgfx.core.path.PathException;
import de.saxsys.svgfx.core.path.commands.BezierCurveCommand;
import de.saxsys.svgfx.core.path.commands.CloseCommand;
import de.saxsys.svgfx.core.path.commands.CubicBezierCurveCommand;
import de.saxsys.svgfx.core.path.commands.HorizontalLineCommand;
import de.saxsys.svgfx.core.path.commands.LineCommand;
import de.saxsys.svgfx.core.path.commands.MoveCommand;
import de.saxsys.svgfx.core.path.commands.PathCommand;
import de.saxsys.svgfx.core.path.commands.QuadraticBezierCurveCommand;
import de.saxsys.svgfx.core.path.commands.VerticalLineCommand;
import de.saxsys.svgfx.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.geometry.Point2D;

public final class CommandFactory {
    private static final String INVALID_NUMBER_FORMAT = "Could not parse given data [%s] into a number";
    private static final String INVALID_COMMAND_NAME = "Given command name [%s] can not be used to create a [%s] required either [%s] or [%s]";

    public PathCommand createCommandOrFail(Character delimiter, String data, Point2D absolutePathStartingPoint, Point2D absoluteCurrentPoint, PathCommand previousCommand) throws PathException {
        if (delimiter == null) {
            throw new PathException(String.format("Can not create command for data %s when no command delimiter was found", data));
        }
        if (CommandName.MOVE.isCommandName(delimiter.charValue())) {
            return this.createMoveCommand(delimiter.charValue(), data);
        }
        if (CommandName.LINE.isCommandName(delimiter.charValue())) {
            return this.createLineCommand(delimiter.charValue(), data);
        }
        if (CommandName.HORIZONTAL_LINE.isCommandName(delimiter.charValue())) {
            return this.createHorizontalLineCommand(delimiter.charValue(), data);
        }
        if (CommandName.VERTICAL_LINE.isCommandName(delimiter.charValue())) {
            return this.createVerticalLineCommand(delimiter.charValue(), data);
        }
        if (CommandName.CLOSE.isCommandName(delimiter.charValue())) {
            return this.createCloseCommand(delimiter.charValue(), absolutePathStartingPoint);
        }
        if (CommandName.CUBIC_BEZIER_CURVE.isCommandName(delimiter.charValue())) {
            return this.createCubicBezierCurveCommand(delimiter.charValue(), data);
        }
        if (CommandName.SHORT_CUBIC_BEZIER_CURVE.isCommandName(delimiter.charValue())) {
            return this.createShortCubicBezierCurveCommand(delimiter.charValue(), data, absoluteCurrentPoint, previousCommand);
        }
        if (CommandName.QUADRATIC_BEZIER_CURVE.isCommandName(delimiter.charValue())) {
            return this.createQuadraticBezierCurveCommand(delimiter.charValue(), data);
        }
        if (CommandName.SHORT_QUADRATIC_BEZIER_CURVE.isCommandName(delimiter.charValue())) {
            return this.createShortQuadraticBezierCurveCommand(delimiter.charValue(), data, absoluteCurrentPoint, previousCommand);
        }
        throw new PathException(String.format("Could not use delimiter: [%s] must be one of the know delimiters", delimiter));
    }

    public MoveCommand createMoveCommand(char commandName, String data) throws PathException {
        this.checkCommandNameOrFail(commandName, CommandName.MOVE, MoveCommand.class);
        Point2D position = this.createPointOrFail(data.trim());
        return new MoveCommand(commandName == CommandName.MOVE.getAbsoluteName(), position);
    }

    public LineCommand createLineCommand(char commandName, String data) throws PathException {
        this.checkCommandNameOrFail(commandName, CommandName.LINE, LineCommand.class);
        Point2D position = this.createPointOrFail(data.trim());
        return new LineCommand(commandName == CommandName.LINE.getAbsoluteName(), position);
    }

    public HorizontalLineCommand createHorizontalLineCommand(char commandName, String data) throws PathException {
        double distance;
        this.checkCommandNameOrFail(commandName, CommandName.HORIZONTAL_LINE, HorizontalLineCommand.class);
        try {
            distance = Double.parseDouble(data.trim());
        }
        catch (NumberFormatException e) {
            throw new PathException(String.format(INVALID_NUMBER_FORMAT, data), e);
        }
        return new HorizontalLineCommand(commandName == CommandName.HORIZONTAL_LINE.getAbsoluteName(), distance);
    }

    public VerticalLineCommand createVerticalLineCommand(char commandName, String data) throws PathException {
        double distance;
        this.checkCommandNameOrFail(commandName, CommandName.VERTICAL_LINE, VerticalLineCommand.class);
        try {
            distance = Double.parseDouble(data.trim());
        }
        catch (NumberFormatException e) {
            throw new PathException(String.format(INVALID_NUMBER_FORMAT, data), e);
        }
        return new VerticalLineCommand(commandName == CommandName.VERTICAL_LINE.getAbsoluteName(), distance);
    }

    public CloseCommand createCloseCommand(char commandName, Point2D startPoint) throws PathException {
        this.checkCommandNameOrFail(commandName, CommandName.CLOSE, CloseCommand.class);
        return new CloseCommand(commandName == CommandName.CLOSE.getAbsoluteName(), startPoint);
    }

    public CubicBezierCurveCommand createCubicBezierCurveCommand(char commandName, String data) throws PathException {
        this.checkCommandNameOrFail(commandName, CommandName.CUBIC_BEZIER_CURVE, CubicBezierCurveCommand.class);
        List<Point2D> points = this.createPointsOrFail(data, 3);
        return new CubicBezierCurveCommand(commandName == CommandName.CUBIC_BEZIER_CURVE.getAbsoluteName(), points.get(0), points.get(1), points.get(2));
    }

    public CubicBezierCurveCommand createShortCubicBezierCurveCommand(char commandName, String data, Point2D absoluteCurrentPoint, PathCommand previousCommand) throws PathException {
        this.checkCommandNameOrFail(commandName, CommandName.SHORT_CUBIC_BEZIER_CURVE, CubicBezierCurveCommand.class);
        List<Point2D> points = this.createPointsOrFail(data, 2);
        boolean isAbsolute = commandName == CommandName.SHORT_CUBIC_BEZIER_CURVE.getAbsoluteName();
        return new CubicBezierCurveCommand(isAbsolute, this.getAdjustedStartControlPoint(isAbsolute, absoluteCurrentPoint, previousCommand), points.get(0), points.get(1));
    }

    public QuadraticBezierCurveCommand createQuadraticBezierCurveCommand(char commandName, String data) throws PathException {
        this.checkCommandNameOrFail(commandName, CommandName.QUADRATIC_BEZIER_CURVE, QuadraticBezierCurveCommand.class);
        List<Point2D> points = this.createPointsOrFail(data, 2);
        return new QuadraticBezierCurveCommand(commandName == CommandName.QUADRATIC_BEZIER_CURVE.getAbsoluteName(), points.get(0), points.get(1));
    }

    public QuadraticBezierCurveCommand createShortQuadraticBezierCurveCommand(char commandName, String data, Point2D absoluteStartPoint, PathCommand previousCommand) throws PathException {
        this.checkCommandNameOrFail(commandName, CommandName.SHORT_QUADRATIC_BEZIER_CURVE, QuadraticBezierCurveCommand.class);
        Point2D endPoint = this.createPointOrFail(data);
        boolean isAbsolute = commandName == CommandName.SHORT_QUADRATIC_BEZIER_CURVE.getAbsoluteName();
        Point2D adjustedControlPoint = this.getAdjustedControlPoint(isAbsolute, absoluteStartPoint, previousCommand);
        return new QuadraticBezierCurveCommand(isAbsolute, adjustedControlPoint, endPoint);
    }

    private void checkCommandNameOrFail(char name, CommandName commandName, Class commandClass) throws PathException {
        if (!commandName.isCommandName(name)) {
            throw new PathException(String.format(INVALID_COMMAND_NAME, Character.valueOf(name), commandClass.getSimpleName(), Character.valueOf(commandName.getAbsoluteName()), Character.valueOf(commandName.getRelativeName())));
        }
    }

    private List<Point2D> createPointsOrFail(String data, int numberOfPoints) throws PathException {
        List<String> values = StringUtil.splitByDelimiters(data, Arrays.asList(Character.valueOf(Constants.WHITESPACE), Character.valueOf(Constants.COMMA)), StringUtil::isNotNullOrEmptyAfterTrim);
        if (values.size() % 2 != 0) {
            throw new PathException(String.format("Data [%s] must have an even number of points but has [%d]", data, values.size()));
        }
        ArrayList<Point2D> points = new ArrayList<Point2D>(0);
        for (int i = 0; i < values.size(); i += 2) {
            Point2D point = this.createPointOrFail(values.get(i), values.get(i + 1));
            points.add(point);
        }
        if (points.size() != numberOfPoints) {
            throw new PathException(String.format("Could not create cubic bezier curve command from data [%s] cause the number of points is [%d] but needs to be [%d]", data, points.size(), numberOfPoints));
        }
        return points;
    }

    private Point2D createPointOrFail(String data) throws PathException {
        List<String> split;
        if (StringUtil.isNullOrEmpty(data)) {
            throw new PathException(String.format("Given data: [%s] can not be used to create a move command", data));
        }
        try {
            split = StringUtil.splitByDelimiters(data, Arrays.asList(Character.valueOf(Constants.WHITESPACE), Character.valueOf(Constants.COMMA)), StringUtil::isNotNullOrEmptyAfterTrim);
        }
        catch (Exception e) {
            throw new PathException(String.format("Given data: [%s] can not be used to create a move command", data), e);
        }
        if (split.size() != 2) {
            throw new PathException(String.format("Given data: [%s] can not be used to create a move command", data));
        }
        return this.createPointOrFail(split.get(0), split.get(1));
    }

    private Point2D createPointOrFail(String xValue, String yValue) throws PathException {
        Double y;
        Double x;
        try {
            x = Double.parseDouble(xValue.trim());
        }
        catch (NumberFormatException e) {
            throw new PathException(String.format("Given data: [%s] can not be used to create a move command", xValue), e);
        }
        try {
            y = Double.parseDouble(yValue.trim());
        }
        catch (NumberFormatException e) {
            throw new PathException(String.format("Given data: [%s] can not be used to create a move command", yValue), e);
        }
        return new Point2D(x.doubleValue(), y.doubleValue());
    }

    private Point2D getAdjustedStartControlPoint(boolean isAbsolute, Point2D absoluteCurrentPoint, PathCommand command) throws PathException {
        return this.getAdjustedPoint(isAbsolute, absoluteCurrentPoint, command, CubicBezierCurveCommand.class, CubicBezierCurveCommand::getAbsoluteEndControlPoint);
    }

    private Point2D getAdjustedControlPoint(boolean isAbsolute, Point2D absoluteCurrentPoint, PathCommand command) throws PathException {
        return this.getAdjustedPoint(isAbsolute, absoluteCurrentPoint, command, QuadraticBezierCurveCommand.class, QuadraticBezierCurveCommand::getAbsoluteControlPoint);
    }

    private <T extends BezierCurveCommand> Point2D getAdjustedPoint(boolean isAbsolute, Point2D absoluteCurrentPoint, PathCommand command, Class<T> clazz, ThrowableBiFunction<T, Point2D, Point2D, PathException> controlPointSupplier) throws PathException {
        Point2D startPoint;
        Point2D negativeDistance;
        if (command != null && clazz.isAssignableFrom(command.getClass())) {
            BezierCurveCommand bezierCurveCommand = (BezierCurveCommand)clazz.cast(command);
            Point2D absoluteEndPoint = bezierCurveCommand.getAbsoluteEndPoint(absoluteCurrentPoint);
            Point2D absoluteControlPoint = controlPointSupplier.apply(bezierCurveCommand, absoluteCurrentPoint);
            negativeDistance = absoluteControlPoint.subtract(absoluteEndPoint).multiply(-1.0);
            startPoint = absoluteEndPoint;
        } else {
            negativeDistance = Point2D.ZERO;
            startPoint = absoluteCurrentPoint;
        }
        if (isAbsolute) {
            return startPoint.add(negativeDistance);
        }
        return negativeDistance;
    }
}

