/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.core.path.commands;

import de.saxsys.svgfx.core.path.PathException;
import de.saxsys.svgfx.core.path.commands.PathCommand;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javafx.geometry.Point2D;
import javafx.scene.shape.Rectangle;

public abstract class BezierCurveCommand
extends PathCommand {
    private static final double NEAR_NULL = 1.0E-12;
    private final Point2D endPoint;

    BezierCurveCommand(boolean isAbsolute, Point2D endPoint) {
        super(isAbsolute);
        this.endPoint = endPoint;
    }

    public Point2D getEndPoint() {
        return this.endPoint;
    }

    public abstract Point2D getAbsoluteStartControlPoint(Point2D var1) throws PathException;

    public abstract Point2D getAbsoluteEndControlPoint(Point2D var1) throws PathException;

    @Override
    public Point2D getAbsoluteEndPoint(Point2D absoluteCurrentPoint) throws PathException {
        return this.addPoints(absoluteCurrentPoint, this.endPoint);
    }

    @Override
    public Optional<Rectangle> getBoundingBox(Point2D absoluteCurrentPoint) throws PathException {
        if (absoluteCurrentPoint == null) {
            throw new PathException("Can not create bounding box with missing start position");
        }
        Point2D absoluteStartControlPoint = this.getAbsoluteStartControlPoint(absoluteCurrentPoint);
        Point2D absoluteEndControlPoint = this.getAbsoluteEndControlPoint(absoluteCurrentPoint);
        Point2D absoluteEndPoint = this.getAbsoluteEndPoint(absoluteCurrentPoint);
        List<Double> localExtrema = this.getExtremaValues(absoluteCurrentPoint, absoluteStartControlPoint, absoluteEndControlPoint, absoluteEndPoint);
        double minX = Math.min(absoluteCurrentPoint.getX(), absoluteEndPoint.getX());
        double maxX = Math.max(absoluteCurrentPoint.getX(), absoluteEndPoint.getX());
        double minY = Math.min(absoluteCurrentPoint.getY(), absoluteEndPoint.getY());
        double maxY = Math.max(absoluteCurrentPoint.getY(), absoluteEndPoint.getY());
        for (Double t : localExtrema) {
            Point2D curvePosition = this.getCurvePoint(t, absoluteCurrentPoint, absoluteStartControlPoint, absoluteEndControlPoint, absoluteEndPoint);
            minX = Math.min(minX, curvePosition.getX());
            maxX = Math.max(maxX, curvePosition.getX());
            minY = Math.min(minY, curvePosition.getY());
            maxY = Math.max(maxY, curvePosition.getY());
        }
        return Optional.of(new Rectangle(minX, minY, maxX - minX, maxY - minY));
    }

    private Point2D getCurvePoint(Double t, Point2D start, Point2D startControl, Point2D endControl, Point2D end) {
        Double mt = 1.0 - t;
        Double tEnd = Math.pow(t, 3.0);
        Double tEndControl = 3.0 * Math.pow(t, 2.0) * mt;
        Double mtStart = Math.pow(mt, 3.0);
        Double mtStartControl = 3.0 * Math.pow(mt, 2.0) * t;
        Double x = mtStart * start.getX() + mtStartControl * startControl.getX() + tEndControl * endControl.getX() + tEnd * end.getX();
        Double y = mtStart * start.getY() + mtStartControl * startControl.getY() + tEndControl * endControl.getY() + tEnd * end.getY();
        return new Point2D(x.doubleValue(), y.doubleValue());
    }

    private List<Double> getExtremaValues(Point2D start, Point2D startControl, Point2D endControl, Point2D end) {
        ArrayList<Double> result = new ArrayList<Double>(0);
        result.addAll(this.getExtremaValues(start.getX(), startControl.getX(), endControl.getX(), end.getX()));
        result.addAll(this.getExtremaValues(start.getY(), startControl.getY(), endControl.getY(), end.getY()));
        return result;
    }

    private List<Double> getExtremaValues(Double start, Double startControl, Double endControl, Double end) {
        ArrayList<Double> result = new ArrayList<Double>(0);
        Double a = -3.0 * start + 9.0 * startControl - 9.0 * endControl + 3.0 * end;
        Double b = 6.0 * start - 12.0 * startControl + 6.0 * endControl;
        Double c = 3.0 * startControl - 3.0 * start;
        Double b2ac = b * b - 4.0 * c * a;
        Double sqrtb2ac = Math.sqrt(b2ac);
        if (this.isSmallerOrNearNull(Math.abs(a)) && !this.isSmallerOrNearNull(Math.abs(b))) {
            double t = -c.doubleValue() / b;
            if (0.0 < t && t < 1.0) {
                result.add(t);
            }
        } else if (b2ac >= 0.0) {
            Double t2;
            Double t1 = (-b.doubleValue() + sqrtb2ac) / (2.0 * a);
            if (0.0 < t1 && t1 < 1.0) {
                result.add(t1);
            }
            if (0.0 < (t2 = Double.valueOf((-b.doubleValue() - sqrtb2ac) / (2.0 * a))) && t2 < 1.0) {
                result.add(t2);
            }
        }
        return result;
    }

    private boolean isSmallerOrNearNull(double value) {
        return value < 1.0E-12;
    }
}

