/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.core.path;

import de.saxsys.svgfx.core.path.CommandName;
import de.saxsys.svgfx.core.path.PathException;
import de.saxsys.svgfx.core.path.commands.CommandFactory;
import de.saxsys.svgfx.core.path.commands.MoveCommand;
import de.saxsys.svgfx.core.path.commands.PathCommand;
import de.saxsys.svgfx.core.utils.StringUtil;
import de.saxsys.svgfx.core.utils.Wrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import javafx.geometry.Point2D;
import javafx.scene.shape.Rectangle;

public class CommandParser {
    private static final Collection<Character> COMMAND_NAMES;
    private final CommandFactory commandFactory;

    public CommandParser(CommandFactory commandFactory) {
        this.commandFactory = commandFactory;
    }

    public Rectangle getBoundingBox(String path) throws PathException {
        if (StringUtil.isNullOrEmpty(path)) {
            throw new PathException("Can not get bounding box from empty path command");
        }
        Wrapper startPoint = new Wrapper();
        Wrapper currentPoint = new Wrapper();
        Wrapper previousCommand = new Wrapper();
        Wrapper previousBoundingBox = new Wrapper();
        StringUtil.splitByDelimiters(path, COMMAND_NAMES, (delimiter, data) -> {
            PathCommand nextCommand = this.commandFactory.createCommandOrFail((Character)delimiter, (String)data, startPoint.getOptional().orElse(Point2D.ZERO), currentPoint.getOptional().orElse(Point2D.ZERO), (PathCommand)previousCommand.get());
            Optional<Rectangle> nextBoundingBox = this.getNextBoundingBox(nextCommand, currentPoint.getOptional().orElse(Point2D.ZERO), previousBoundingBox);
            nextBoundingBox.ifPresent(previousBoundingBox::set);
            this.setStartPosition(startPoint, currentPoint, nextCommand);
            currentPoint.set(nextCommand.getAbsoluteEndPoint((Point2D)currentPoint.get()));
        });
        return (Rectangle)previousBoundingBox.getOptional().orElseThrow(() -> new PathException(String.format("Could not get bounding box from data [%s]", path)));
    }

    private Optional<Rectangle> getNextBoundingBox(PathCommand currentCommand, Point2D previousPoint, Wrapper<Rectangle> previousBoundingBox) throws PathException {
        Optional<Rectangle> commandBoundingBox = currentCommand.getBoundingBox(previousPoint);
        Optional<Object> result = commandBoundingBox.isPresent() && previousBoundingBox.getOptional().isPresent() ? Optional.of(this.combineBoundingBoxes(commandBoundingBox.get(), previousBoundingBox.get())) : (commandBoundingBox.isPresent() ? commandBoundingBox : (previousBoundingBox.getOptional().isPresent() ? previousBoundingBox.getOptional() : Optional.empty()));
        return result;
    }

    private Rectangle combineBoundingBoxes(Rectangle first, Rectangle second) {
        double minX = Math.min(first.getX(), second.getX());
        double minY = Math.min(first.getY(), second.getY());
        double maxX = Math.max(first.getX() + first.getWidth(), second.getX() + second.getWidth());
        double maxY = Math.max(first.getY() + first.getHeight(), second.getY() + second.getHeight());
        return new Rectangle(minX, minY, Math.abs(minX - maxX), Math.abs(minY - maxY));
    }

    private void setStartPosition(Wrapper<Point2D> startPosition, Wrapper<Point2D> previousPosition, PathCommand command) {
        if (!startPosition.getOptional().isPresent() && previousPosition.getOptional().isPresent() && !MoveCommand.class.isAssignableFrom(command.getClass())) {
            startPosition.set(previousPosition.get());
        }
    }

    static {
        ArrayList<Character> values = new ArrayList<Character>(CommandName.values().length * 2);
        for (CommandName commandName : CommandName.values()) {
            values.addAll(commandName.getNames());
        }
        COMMAND_NAMES = values;
    }
}

