/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.core.path;

import java.util.Arrays;
import java.util.Collection;

public enum CommandName {
    MOVE('M'),
    LINE('L'),
    CLOSE('Z'),
    HORIZONTAL_LINE('H'),
    VERTICAL_LINE('V'),
    CUBIC_BEZIER_CURVE('C'),
    SHORT_CUBIC_BEZIER_CURVE('S'),
    QUADRATIC_BEZIER_CURVE('Q'),
    SHORT_QUADRATIC_BEZIER_CURVE('T');

    private final char absoluteName;
    private final char relativeName;

    private CommandName(char name) {
        this.absoluteName = Character.toUpperCase(name);
        this.relativeName = Character.toLowerCase(name);
    }

    public boolean isCommandName(char name) {
        return this.absoluteName == name || this.relativeName == name;
    }

    public char getAbsoluteName() {
        return this.absoluteName;
    }

    public char getRelativeName() {
        return this.relativeName;
    }

    public Collection<Character> getNames() {
        return Arrays.asList(Character.valueOf(this.absoluteName), Character.valueOf(this.relativeName));
    }
}

