/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.core.elements;

import de.saxsys.svgfx.core.SVGDocumentDataProvider;
import de.saxsys.svgfx.core.SVGException;
import de.saxsys.svgfx.core.attributes.PresentationAttributeMapper;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeHolder;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeTypeDouble;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeTypeLength;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeTypePaint;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeTypeRectangle;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeTypeStrokeDashArray;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeTypeStrokeLineCap;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeTypeStrokeLineJoin;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeTypeStrokeType;
import de.saxsys.svgfx.core.css.SVGCssStyle;
import de.saxsys.svgfx.core.elements.SVGNodeBase;
import java.util.ArrayList;
import java.util.Optional;
import javafx.scene.paint.Color;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;
import javafx.scene.transform.Transform;
import org.xml.sax.Attributes;

public abstract class SVGShapeBase<TShape extends Shape>
extends SVGNodeBase<TShape> {
    protected SVGShapeBase(String name, Attributes attributes, SVGDocumentDataProvider dataProvider) {
        super(name, attributes, dataProvider);
    }

    @Override
    protected void initializeResult(TShape result, SVGCssStyle ownStyle, Transform ownTransform) throws SVGException {
        super.initializeResult(result, ownStyle, ownTransform);
        this.applyStyle(result, ownStyle, ownTransform);
    }

    private void applyStyle(TShape shape, SVGCssStyle ownStyle, Transform transform) throws SVGException {
        Optional<SVGAttributeTypeDouble> strokeMiterLimit;
        Optional<SVGAttributeTypeStrokeLineCap> strokeLineCap;
        Optional<SVGAttributeTypeStrokeLineJoin> strokeLineJoin;
        Optional<SVGAttributeTypeLength> strokeDashOffset;
        Optional<SVGAttributeTypeStrokeDashArray> strokeDashArray;
        Optional<SVGAttributeTypeStrokeType> strokeType;
        Optional<SVGAttributeTypeLength> strokeWidth;
        Optional<SVGAttributeTypePaint> stroke;
        if (shape == null) {
            throw new IllegalArgumentException("Given shape must not be null");
        }
        Optional<SVGAttributeTypePaint> fill = ((SVGAttributeHolder)ownStyle.getAttributeHolder()).getAttribute(PresentationAttributeMapper.FILL.getName(), SVGAttributeTypePaint.class);
        if (fill.isPresent()) {
            Paint paint = fill.get().getValue(() -> this.createBoundingBox(shape), transform);
            Optional<SVGAttributeTypeDouble> opacity = ((SVGAttributeHolder)ownStyle.getAttributeHolder()).getAttribute(PresentationAttributeMapper.OPACITY.getName(), SVGAttributeTypeDouble.class);
            if (opacity.isPresent()) {
                paint = this.applyOpacity(paint, (Double)opacity.get().getValue());
            }
            shape.setFill(paint);
        }
        if ((stroke = ((SVGAttributeHolder)ownStyle.getAttributeHolder()).getAttribute(PresentationAttributeMapper.STROKE.getName(), SVGAttributeTypePaint.class)).isPresent()) {
            Paint paint = stroke.get().getValue(() -> this.createBoundingBox(shape), transform);
            Optional<SVGAttributeTypeDouble> opacity = ((SVGAttributeHolder)ownStyle.getAttributeHolder()).getAttribute(PresentationAttributeMapper.STROKE_OPACITY.getName(), SVGAttributeTypeDouble.class);
            if (opacity.isPresent()) {
                paint = this.applyOpacity(paint, (Double)opacity.get().getValue());
            }
            shape.setStroke(paint);
        }
        if ((strokeWidth = ((SVGAttributeHolder)ownStyle.getAttributeHolder()).getAttribute(PresentationAttributeMapper.STROKE_WIDTH.getName(), SVGAttributeTypeLength.class)).isPresent()) {
            shape.setStrokeWidth(((Double)strokeWidth.get().getValue()).doubleValue());
        }
        if ((strokeType = ((SVGAttributeHolder)ownStyle.getAttributeHolder()).getAttribute(PresentationAttributeMapper.STROKE_TYPE.getName(), SVGAttributeTypeStrokeType.class)).isPresent()) {
            shape.setStrokeType((StrokeType)strokeType.get().getValue());
        }
        if ((strokeDashArray = ((SVGAttributeHolder)ownStyle.getAttributeHolder()).getAttribute(PresentationAttributeMapper.STROKE_DASHARRAY.getName(), SVGAttributeTypeStrokeDashArray.class)).isPresent()) {
            shape.getStrokeDashArray().clear();
            shape.getStrokeDashArray().addAll(strokeDashArray.get().getDashValues());
        }
        if ((strokeDashOffset = ((SVGAttributeHolder)ownStyle.getAttributeHolder()).getAttribute(PresentationAttributeMapper.STROKE_DASHOFFSET.getName(), SVGAttributeTypeLength.class)).isPresent()) {
            shape.setStrokeDashOffset(((Double)strokeDashOffset.get().getValue()).doubleValue());
        }
        if ((strokeLineJoin = ((SVGAttributeHolder)ownStyle.getAttributeHolder()).getAttribute(PresentationAttributeMapper.STROKE_LINEJOIN.getName(), SVGAttributeTypeStrokeLineJoin.class)).isPresent()) {
            shape.setStrokeLineJoin((StrokeLineJoin)strokeLineJoin.get().getValue());
        }
        if ((strokeLineCap = ((SVGAttributeHolder)ownStyle.getAttributeHolder()).getAttribute(PresentationAttributeMapper.STROKE_LINECAP.getName(), SVGAttributeTypeStrokeLineCap.class)).isPresent()) {
            shape.setStrokeLineCap((StrokeLineCap)strokeLineCap.get().getValue());
        }
        if ((strokeMiterLimit = ((SVGAttributeHolder)ownStyle.getAttributeHolder()).getAttribute(PresentationAttributeMapper.STROKE_MITERLIMIT.getName(), SVGAttributeTypeDouble.class)).isPresent()) {
            shape.setStrokeMiterLimit(((Double)strokeMiterLimit.get().getValue()).doubleValue());
        }
    }

    private Paint applyOpacity(Paint paint, double opacity) {
        if (paint instanceof Color) {
            Color color = (Color)paint;
            return new Color(color.getRed(), color.getGreen(), color.getBlue(), opacity);
        }
        if (paint instanceof LinearGradient) {
            LinearGradient gradient = (LinearGradient)paint;
            ArrayList newStops = new ArrayList();
            gradient.getStops().forEach(stop -> newStops.add(new Stop(stop.getOffset(), new Color(stop.getColor().getRed(), stop.getColor().getGreen(), stop.getColor().getBlue(), opacity))));
            return new LinearGradient(gradient.getStartX(), gradient.getStartY(), gradient.getEndX(), gradient.getEndY(), gradient.isProportional(), gradient.getCycleMethod(), newStops);
        }
        if (paint instanceof RadialGradient) {
            RadialGradient gradient = (RadialGradient)paint;
            ArrayList newStops = new ArrayList();
            gradient.getStops().forEach(stop -> newStops.add(new Stop(stop.getOffset(), new Color(stop.getColor().getRed(), stop.getColor().getGreen(), stop.getColor().getBlue(), opacity))));
            return new RadialGradient(gradient.getFocusAngle(), gradient.getFocusDistance(), gradient.getCenterX(), gradient.getCenterY(), gradient.getRadius(), gradient.isProportional(), gradient.getCycleMethod(), newStops);
        }
        return paint;
    }

    protected abstract SVGAttributeTypeRectangle.SVGTypeRectangle createBoundingBox(TShape var1) throws SVGException;
}

