/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.core.elements;

import de.saxsys.svgfx.core.SVGDocumentDataProvider;
import de.saxsys.svgfx.core.SVGException;
import de.saxsys.svgfx.core.attributes.CoreAttributeMapper;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeHolder;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeTypeCycleMethod;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeTypeRectangle;
import de.saxsys.svgfx.core.definitions.enumerations.GradientUnit;
import de.saxsys.svgfx.core.elements.SVGGradientBase;
import de.saxsys.svgfx.core.utils.Wrapper;
import java.util.Arrays;
import java.util.List;
import javafx.geometry.Point2D;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Rectangle;
import javafx.scene.transform.Transform;
import org.xml.sax.Attributes;

public class SVGRadialGradient
extends SVGGradientBase<RadialGradient> {
    public static final String ELEMENT_NAME = "radialGradient";
    private static final Double DEFAULT_RADIUS = 0.5;
    private static final Double DEFAULT_CENTER = 0.5;

    SVGRadialGradient(String name, Attributes attributes, SVGDocumentDataProvider dataProvider) {
        super(name, attributes, dataProvider);
    }

    @Override
    public RadialGradient createResult(SVGAttributeTypeRectangle.SVGTypeRectangle elementBoundingBox, Transform elementTransform) throws SVGException {
        return this.determineResult(elementBoundingBox, elementTransform);
    }

    private RadialGradient determineResult(SVGAttributeTypeRectangle.SVGTypeRectangle elementBoundingBox, Transform elementTransform) throws SVGException {
        List<Stop> stops = this.getStops();
        if (stops.isEmpty()) {
            throw new SVGException("Given radial gradient does not have stop colors");
        }
        double centerX = ((SVGAttributeHolder)this.getAttributeHolder()).getAttributeValue(CoreAttributeMapper.CENTER_X.getName(), Double.class, DEFAULT_CENTER);
        double centerY = ((SVGAttributeHolder)this.getAttributeHolder()).getAttributeValue(CoreAttributeMapper.CENTER_Y.getName(), Double.class, DEFAULT_CENTER);
        Wrapper<Point2D> center = new Wrapper<Point2D>(new Point2D(centerX, centerY));
        double focusX = ((SVGAttributeHolder)this.getAttributeHolder()).getAttributeValue(CoreAttributeMapper.FOCUS_X.getName(), Double.class, centerX);
        double focusY = ((SVGAttributeHolder)this.getAttributeHolder()).getAttributeValue(CoreAttributeMapper.FOCUS_Y.getName(), Double.class, centerY);
        Wrapper<Point2D> focus = new Wrapper<Point2D>(new Point2D(focusX, focusY));
        Wrapper<Double> radius = new Wrapper<Double>(((SVGAttributeHolder)this.getAttributeHolder()).getAttributeValue(CoreAttributeMapper.RADIUS.getName(), Double.class, DEFAULT_RADIUS));
        this.convertToRelativeCoordinates(center, focus, radius, elementBoundingBox, elementTransform);
        double diffX = focus.getOrFail().getX() - center.getOrFail().getX();
        double diffY = focus.getOrFail().getY() - center.getOrFail().getY();
        double focusDistance = this.getDistance(diffX, diffY);
        return new RadialGradient(Math.toDegrees(Math.atan2(diffY, diffX)), focusDistance > radius.get() ? 1.0 : focusDistance / radius.get(), center.getOrFail().getX(), center.getOrFail().getY(), radius.get().doubleValue(), true, ((SVGAttributeHolder)this.getAttributeHolder()).getAttributeValue(CoreAttributeMapper.SPREAD_METHOD.getName(), CycleMethod.class, SVGAttributeTypeCycleMethod.DEFAULT_VALUE), stops);
    }

    private void convertToRelativeCoordinates(Wrapper<Point2D> center, Wrapper<Point2D> focus, Wrapper<Double> radius, SVGAttributeTypeRectangle.SVGTypeRectangle elementBoundingBox, Transform elementTransform) throws SVGException {
        Rectangle boundingBox = this.transformBoundingBox(elementBoundingBox, elementTransform);
        GradientUnit gradientUnit = ((SVGAttributeHolder)this.getAttributeHolder()).getAttributeValue(CoreAttributeMapper.GRADIENT_UNITS.getName(), GradientUnit.class, GradientUnit.OBJECT_BOUNDING_BOX);
        List<Wrapper<Point2D>> points = Arrays.asList(center, focus);
        if (gradientUnit == GradientUnit.USER_SPACE_ON_USE) {
            this.getCombinedTransform(elementTransform).ifPresent(transform -> this.transformPosition(center, focus, radius, (Transform)transform));
            this.convertToRelativeCoordinates(boundingBox, radius, points);
        } else {
            this.convertToAbsoluteCoordinates(boundingBox, radius, points);
            this.getGradientTransform().ifPresent(transform -> this.transformPosition(center, focus, radius, (Transform)transform));
            this.convertToRelativeCoordinates(boundingBox, radius, points);
        }
    }

    private void transformPosition(Wrapper<Point2D> center, Wrapper<Point2D> focus, Wrapper<Double> radius, Transform transform) {
        Wrapper<Point2D> radiusP = new Wrapper<Point2D>(new Point2D(center.getOrFail().getX() + radius.get(), center.getOrFail().getY() + radius.get()));
        center.set(transform.transform(center.getOrFail()));
        focus.set(transform.transform(focus.getOrFail()));
        radiusP.set(transform.transform(radiusP.getOrFail()));
        double radiusXTmp = radiusP.getOrFail().getX() - center.getOrFail().getX();
        double radiusYTmp = radiusP.getOrFail().getY() - center.getOrFail().getY();
        radius.set(radiusXTmp > radiusYTmp ? radiusXTmp : radiusYTmp);
    }

    private void convertToRelativeCoordinates(Rectangle boundingBox, Wrapper<Double> radius, List<Wrapper<Point2D>> points) throws SVGException {
        if (boundingBox.getWidth() == 0.0 || boundingBox.getHeight() == 0.0) {
            return;
        }
        this.convertToRelativeCoordinates(boundingBox, points);
        radius.set(radius.get() / (boundingBox.getHeight() > boundingBox.getWidth() ? boundingBox.getHeight() : boundingBox.getWidth()));
    }

    private void convertToAbsoluteCoordinates(Rectangle boundingBox, Wrapper<Double> radius, List<Wrapper<Point2D>> points) throws SVGException {
        if (boundingBox.getWidth() == 0.0 || boundingBox.getHeight() == 0.0) {
            return;
        }
        this.convertToAbsoluteCoordinates(boundingBox, points);
        radius.set(radius.get() * (boundingBox.getHeight() > boundingBox.getWidth() ? boundingBox.getHeight() : boundingBox.getWidth()));
    }

    private double getDistance(double diffX, double diffY) {
        return diffX == 0.0 ? Math.abs(diffY) : (diffY == 0.0 ? Math.abs(diffX) : Math.hypot(diffX, diffY));
    }
}

