/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.core.elements;

import de.saxsys.svgfx.core.SVGDocumentDataProvider;
import de.saxsys.svgfx.core.SVGException;
import de.saxsys.svgfx.core.attributes.CoreAttributeMapper;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeHolder;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeTypeLength;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeTypePoint;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeTypePoints;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeTypeRectangle;
import de.saxsys.svgfx.core.elements.SVGShapeBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.scene.shape.Shape;
import org.xml.sax.Attributes;

public abstract class SVGPolyBase<TShape extends Shape>
extends SVGShapeBase<TShape> {
    protected SVGPolyBase(String name, Attributes attributes, SVGDocumentDataProvider dataProvider) {
        super(name, attributes, dataProvider);
    }

    public final List<Double> getPoints() throws SVGException {
        ArrayList<Double> actualPoints = new ArrayList<Double>();
        Optional<SVGAttributeTypePoints> points = ((SVGAttributeHolder)this.getAttributeHolder()).getAttribute(CoreAttributeMapper.POINTS.getName(), SVGAttributeTypePoints.class);
        if (points.isPresent()) {
            for (SVGAttributeTypePoint point : (List)points.get().getValue()) {
                actualPoints.add((Double)((SVGAttributeTypePoint.SVGTypePoint)point.getValue()).getX().getValue());
                actualPoints.add((Double)((SVGAttributeTypePoint.SVGTypePoint)point.getValue()).getY().getValue());
            }
        }
        return actualPoints;
    }

    @Override
    protected SVGAttributeTypeRectangle.SVGTypeRectangle createBoundingBox(TShape shape) throws SVGException {
        SVGAttributeTypeRectangle.SVGTypeRectangle result = new SVGAttributeTypeRectangle.SVGTypeRectangle((SVGDocumentDataProvider)this.getDocumentDataProvider());
        AtomicBoolean isFirstRun = new AtomicBoolean(true);
        Optional<SVGAttributeTypePoints> points = ((SVGAttributeHolder)this.getAttributeHolder()).getAttribute(CoreAttributeMapper.POINTS.getName(), SVGAttributeTypePoints.class);
        if (points.isPresent()) {
            for (SVGAttributeTypePoint point : (List)points.get().getValue()) {
                if (isFirstRun.get() || (Double)result.getMinX().getValue() > (Double)((SVGAttributeTypePoint.SVGTypePoint)point.getValue()).getX().getValue()) {
                    result.getMinX().setText(String.format("%f%s", ((SVGAttributeTypePoint.SVGTypePoint)point.getValue()).getX().getValue(), ((SVGAttributeTypeLength.Unit)((Object)((SVGAttributeTypePoint.SVGTypePoint)point.getValue()).getX().getUnit())).getName()));
                }
                if (isFirstRun.get() || (Double)result.getMinY().getValue() > (Double)((SVGAttributeTypePoint.SVGTypePoint)point.getValue()).getY().getValue()) {
                    result.getMinY().setText(String.format("%f%s", ((SVGAttributeTypePoint.SVGTypePoint)point.getValue()).getY().getValue(), ((SVGAttributeTypeLength.Unit)((Object)((SVGAttributeTypePoint.SVGTypePoint)point.getValue()).getY().getUnit())).getName()));
                }
                if (isFirstRun.get() || (Double)result.getMaxX().getValue() < (Double)((SVGAttributeTypePoint.SVGTypePoint)point.getValue()).getX().getValue()) {
                    result.getMaxX().setText(String.format("%f%s", ((SVGAttributeTypePoint.SVGTypePoint)point.getValue()).getX().getValue(), ((SVGAttributeTypeLength.Unit)((Object)((SVGAttributeTypePoint.SVGTypePoint)point.getValue()).getX().getUnit())).getName()));
                }
                if (isFirstRun.get() || (Double)result.getMaxY().getValue() < (Double)((SVGAttributeTypePoint.SVGTypePoint)point.getValue()).getY().getValue()) {
                    result.getMaxY().setText(String.format("%f%s", ((SVGAttributeTypePoint.SVGTypePoint)point.getValue()).getY().getValue(), ((SVGAttributeTypeLength.Unit)((Object)((SVGAttributeTypePoint.SVGTypePoint)point.getValue()).getY().getUnit())).getName()));
                }
                if (!isFirstRun.get()) continue;
                isFirstRun.set(false);
            }
        }
        return result;
    }
}

