/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.core.elements;

import de.saxsys.svgfx.core.SVGDocumentDataProvider;
import de.saxsys.svgfx.core.SVGException;
import de.saxsys.svgfx.core.attributes.CoreAttributeMapper;
import de.saxsys.svgfx.core.attributes.PresentationAttributeMapper;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeHolder;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeTypeFillRule;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeTypeRectangle;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeTypeString;
import de.saxsys.svgfx.core.css.SVGCssStyle;
import de.saxsys.svgfx.core.elements.SVGShapeBase;
import de.saxsys.svgfx.core.path.CommandParser;
import de.saxsys.svgfx.core.path.PathException;
import java.util.Optional;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.Rectangle;
import javafx.scene.transform.Transform;
import org.xml.sax.Attributes;

public class SVGPath
extends SVGShapeBase<javafx.scene.shape.SVGPath> {
    public static final String ELEMENT_NAME = "path";
    private final CommandParser commandParser;

    SVGPath(String name, Attributes attributes, SVGDocumentDataProvider dataProvider, CommandParser commandParser) {
        super(name, attributes, dataProvider);
        this.commandParser = commandParser;
    }

    @Override
    protected final javafx.scene.shape.SVGPath createResult(SVGCssStyle ownStyle, Transform ownTransform) throws SVGException {
        javafx.scene.shape.SVGPath result = new javafx.scene.shape.SVGPath();
        Optional<SVGAttributeTypeString> path = ((SVGAttributeHolder)this.getAttributeHolder()).getAttribute(CoreAttributeMapper.PATH_DESCRIPTION.getName(), SVGAttributeTypeString.class);
        if (path.isPresent()) {
            result.setContent((String)path.get().getValue());
        }
        return result;
    }

    @Override
    protected final void initializeResult(javafx.scene.shape.SVGPath result, SVGCssStyle ownStyle, Transform ownTransform) throws SVGException {
        super.initializeResult(result, ownStyle, ownTransform);
        Optional<SVGAttributeTypeFillRule> fillRule = ((SVGAttributeHolder)ownStyle.getAttributeHolder()).getAttribute(PresentationAttributeMapper.FILL_RULE.getName(), SVGAttributeTypeFillRule.class);
        if (fillRule.isPresent()) {
            result.setFillRule((FillRule)fillRule.get().getValue());
        }
    }

    @Override
    protected SVGAttributeTypeRectangle.SVGTypeRectangle createBoundingBox(javafx.scene.shape.SVGPath shape) throws SVGException {
        Rectangle boundingBox;
        String path = (String)((SVGAttributeHolder)this.getAttributeHolder()).getAttributeOrFail(CoreAttributeMapper.PATH_DESCRIPTION.getName(), SVGAttributeTypeString.class).getValue();
        try {
            boundingBox = this.commandParser.getBoundingBox(path);
        }
        catch (PathException e) {
            throw new SVGException(String.format("Could not parse path [%s]", path), e);
        }
        SVGAttributeTypeRectangle.SVGTypeRectangle result = new SVGAttributeTypeRectangle.SVGTypeRectangle((SVGDocumentDataProvider)this.getDocumentDataProvider());
        result.getMinX().setText(String.format("%f", boundingBox.getX()));
        result.getMinY().setText(String.format("%f", boundingBox.getY()));
        result.getMaxX().setText(String.format("%f", boundingBox.getX() + boundingBox.getWidth()));
        result.getMaxY().setText(String.format("%f", boundingBox.getY() + boundingBox.getHeight()));
        return result;
    }
}

