/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.core.elements;

import de.saxsys.svgfx.core.SVGDocumentDataProvider;
import de.saxsys.svgfx.core.SVGException;
import de.saxsys.svgfx.core.attributes.PresentationAttributeMapper;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeHolder;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeTypeString;
import de.saxsys.svgfx.core.css.SVGCssStyle;
import de.saxsys.svgfx.core.elements.SVGClipPath;
import de.saxsys.svgfx.core.elements.SVGElementBase;
import de.saxsys.svgfx.core.utils.SVGUtil;
import de.saxsys.svgfx.core.utils.StringUtil;
import java.util.Optional;
import javafx.scene.Node;
import javafx.scene.transform.Transform;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class SVGNodeBase<TNode extends Node>
extends SVGElementBase<TNode> {
    protected SVGNodeBase(String name, Attributes attributes, SVGDocumentDataProvider documentDataProvider) {
        super(name, attributes, documentDataProvider);
    }

    @Override
    public boolean keepElement() {
        return true;
    }

    @Override
    public void processCharacterData(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    protected void initializeResult(TNode result, SVGCssStyle ownStyle, Transform ownTransform) throws SVGException {
        this.getTransformation().ifPresent(transform -> result.getTransforms().add(transform));
        this.getClipPath(ownStyle, ownTransform).ifPresent(arg_0 -> result.setClip(arg_0));
    }

    private Optional<Node> getClipPath(SVGCssStyle ownStyle, Transform ownTransform) throws SVGException {
        Optional<SVGAttributeTypeString> referenceIRI = ((SVGAttributeHolder)ownStyle.getAttributeHolder()).getAttribute(PresentationAttributeMapper.CLIP_PATH.getName(), SVGAttributeTypeString.class);
        if (referenceIRI.isPresent() && StringUtil.isNotNullOrEmpty((String)referenceIRI.get().getValue())) {
            SVGClipPath clipPath = SVGUtil.resolveIRI((String)referenceIRI.get().getValue(), (SVGDocumentDataProvider)this.getDocumentDataProvider(), SVGClipPath.class);
            if (this != clipPath) {
                return Optional.of(clipPath.createAndInitializeResult(ownStyle, ownTransform));
            }
            return Optional.empty();
        }
        return Optional.empty();
    }
}

