/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.core.elements;

import de.saxsys.svgfx.core.SVGDocumentDataProvider;
import de.saxsys.svgfx.core.SVGException;
import de.saxsys.svgfx.core.attributes.CoreAttributeMapper;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeHolder;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeTypeCycleMethod;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeTypeRectangle;
import de.saxsys.svgfx.core.definitions.enumerations.GradientUnit;
import de.saxsys.svgfx.core.elements.SVGGradientBase;
import de.saxsys.svgfx.core.utils.Wrapper;
import java.util.Arrays;
import java.util.List;
import javafx.geometry.Point2D;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Rectangle;
import javafx.scene.transform.Transform;
import org.xml.sax.Attributes;

public class SVGLinearGradient
extends SVGGradientBase<LinearGradient> {
    public static final String ELEMENT_NAME = "linearGradient";
    private static final Double DEFAULT_END_X = 1.0;

    SVGLinearGradient(String name, Attributes attributes, SVGDocumentDataProvider dataProvider) {
        super(name, attributes, dataProvider);
    }

    @Override
    public final LinearGradient createResult(SVGAttributeTypeRectangle.SVGTypeRectangle elementBoundingBox, Transform elementTransform) throws SVGException {
        return this.determineResult(elementBoundingBox, elementTransform);
    }

    private LinearGradient determineResult(SVGAttributeTypeRectangle.SVGTypeRectangle elementBoundingBox, Transform elementTransform) throws SVGException {
        List<Stop> stops = this.getStops();
        if (stops.isEmpty()) {
            throw new SVGException("Given linear gradient does not have stop colors");
        }
        double startX = ((SVGAttributeHolder)this.getAttributeHolder()).getAttributeValue(CoreAttributeMapper.START_X.getName(), Double.class, 0.0);
        double startY = ((SVGAttributeHolder)this.getAttributeHolder()).getAttributeValue(CoreAttributeMapper.START_Y.getName(), Double.class, 0.0);
        Wrapper<Point2D> start = new Wrapper<Point2D>(new Point2D(startX, startY));
        double endX = ((SVGAttributeHolder)this.getAttributeHolder()).getAttributeValue(CoreAttributeMapper.END_X.getName(), Double.class, DEFAULT_END_X);
        double endY = ((SVGAttributeHolder)this.getAttributeHolder()).getAttributeValue(CoreAttributeMapper.END_Y.getName(), Double.class, 0.0);
        Wrapper<Point2D> end = new Wrapper<Point2D>(new Point2D(endX, endY));
        this.convertToRelativeCoordinates(start, end, elementBoundingBox, elementTransform);
        return new LinearGradient(start.getOrFail().getX(), start.getOrFail().getY(), end.getOrFail().getX(), end.getOrFail().getY(), true, ((SVGAttributeHolder)this.getAttributeHolder()).getAttributeValue(CoreAttributeMapper.SPREAD_METHOD.getName(), CycleMethod.class, SVGAttributeTypeCycleMethod.DEFAULT_VALUE), stops);
    }

    private void convertToRelativeCoordinates(Wrapper<Point2D> start, Wrapper<Point2D> end, SVGAttributeTypeRectangle.SVGTypeRectangle elementBoundingBox, Transform elementTransform) throws SVGException {
        Rectangle boundingBox = this.transformBoundingBox(elementBoundingBox, elementTransform);
        GradientUnit gradientUnit = ((SVGAttributeHolder)this.getAttributeHolder()).getAttributeValue(CoreAttributeMapper.GRADIENT_UNITS.getName(), GradientUnit.class, GradientUnit.OBJECT_BOUNDING_BOX);
        List<Wrapper<Point2D>> points = Arrays.asList(start, end);
        if (gradientUnit == GradientUnit.USER_SPACE_ON_USE) {
            this.getCombinedTransform(elementTransform).ifPresent(transform -> this.transformPosition((Transform)transform, start, end));
            this.convertToRelativeCoordinates(boundingBox, points);
        } else {
            this.convertToAbsoluteCoordinates(boundingBox, points);
            this.getGradientTransform().ifPresent(transform -> this.transformPosition((Transform)transform, start, end));
            this.convertToRelativeCoordinates(boundingBox, points);
        }
    }

    private void transformPosition(Transform transform, Wrapper<Point2D> start, Wrapper<Point2D> end) {
        start.set(transform.transform(start.getOrFail()));
        end.set(transform.transform(end.getOrFail()));
    }
}

