/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.core.elements;

import de.saxsys.svgfx.core.SVGDocumentDataProvider;
import de.saxsys.svgfx.core.SVGException;
import de.saxsys.svgfx.core.attributes.CoreAttributeMapper;
import de.saxsys.svgfx.core.attributes.XLinkAttributeMapper;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeHolder;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeTypeRectangle;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeTypeString;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeTypeTransform;
import de.saxsys.svgfx.core.css.SVGCssStyle;
import de.saxsys.svgfx.core.elements.SVGElementBase;
import de.saxsys.svgfx.core.elements.SVGStop;
import de.saxsys.svgfx.core.utils.SVGUtil;
import de.saxsys.svgfx.core.utils.Wrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javafx.geometry.Point2D;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Rectangle;
import javafx.scene.transform.Transform;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class SVGGradientBase<TPaint extends Paint>
extends SVGElementBase<TPaint> {
    protected SVGGradientBase(String name, Attributes attributes, SVGDocumentDataProvider dataProvider) throws IllegalArgumentException {
        super(name, attributes, dataProvider);
    }

    @Override
    public final boolean keepElement() {
        return false;
    }

    @Override
    public final void processCharacterData(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    protected final void initializeResult(TPaint paint, SVGCssStyle ownStyle, Transform ownTransform) throws SVGException {
    }

    public final List<Stop> getStops() throws SVGException {
        Optional<SVGAttributeTypeString> link;
        ArrayList<Stop> stops = new ArrayList<Stop>(0);
        this.fillStopsOrFail(stops, this.getUnmodifiableChildren());
        if (stops.isEmpty() && (link = ((SVGAttributeHolder)this.getAttributeHolder()).getAttribute(XLinkAttributeMapper.XLINK_HREF.getName(), SVGAttributeTypeString.class)).isPresent()) {
            this.fillStopsOrFail(stops, SVGUtil.resolveIRI((String)link.get().getValue(), (SVGDocumentDataProvider)this.getDocumentDataProvider(), SVGElementBase.class).getUnmodifiableChildren());
        }
        return stops;
    }

    protected final void convertToRelativeCoordinates(Rectangle boundingBox, List<Wrapper<Point2D>> points) throws SVGException {
        if (boundingBox.getWidth() == 0.0 || boundingBox.getHeight() == 0.0) {
            return;
        }
        for (Wrapper<Point2D> point : points) {
            point.set(new Point2D(Math.abs(boundingBox.getX() - point.getOrFail().getX()) / boundingBox.getWidth(), Math.abs(boundingBox.getY() - point.getOrFail().getY()) / boundingBox.getHeight()));
        }
    }

    protected final void convertToAbsoluteCoordinates(Rectangle boundingBox, List<Wrapper<Point2D>> points) throws SVGException {
        if (boundingBox.getWidth() == 0.0 || boundingBox.getHeight() == 0.0) {
            return;
        }
        for (Wrapper<Point2D> point : points) {
            point.set(new Point2D(boundingBox.getX() + point.getOrFail().getX() * boundingBox.getWidth(), boundingBox.getY() + point.getOrFail().getY() * boundingBox.getHeight()));
        }
    }

    protected final Rectangle transformBoundingBox(SVGAttributeTypeRectangle.SVGTypeRectangle boundingBox, Transform transform) throws SVGException {
        Rectangle result = new Rectangle(((Double)boundingBox.getMinX().getValue()).doubleValue(), ((Double)boundingBox.getMinY().getValue()).doubleValue(), (Double)boundingBox.getMaxX().getValue() - (Double)boundingBox.getMinX().getValue(), (Double)boundingBox.getMaxY().getValue() - (Double)boundingBox.getMinY().getValue());
        if (transform != null) {
            Point2D minimum = transform.transform(result.getX(), result.getY());
            Point2D maximum = transform.transform(result.getX() + result.getWidth(), result.getY() + result.getHeight());
            result = new Rectangle(minimum.getX(), minimum.getY(), maximum.getX() - minimum.getX(), maximum.getY() - minimum.getY());
        }
        return result;
    }

    protected Optional<Transform> getGradientTransform() throws SVGException {
        Optional<SVGAttributeTypeTransform> ownTransform = ((SVGAttributeHolder)this.getAttributeHolder()).getAttribute(CoreAttributeMapper.GRADIENT_TRANSFORM.getName(), SVGAttributeTypeTransform.class);
        if (ownTransform.isPresent()) {
            return Optional.of(ownTransform.get().getValue());
        }
        return Optional.empty();
    }

    protected Optional<Transform> getCombinedTransform(Transform elementTransform) throws SVGException {
        Optional usedTransform = this.getGradientTransform();
        if (elementTransform != null) {
            usedTransform = usedTransform.map(transform -> Optional.of(elementTransform.createConcatenation(transform))).orElseGet(() -> Optional.of(elementTransform));
        }
        return usedTransform;
    }

    private void fillStopsOrFail(List<Stop> stops, List<SVGElementBase<?>> children) throws SVGException {
        for (SVGElementBase<?> child : children) {
            if (!(child instanceof SVGStop)) continue;
            try {
                stops.add((Stop)((SVGStop)child).getResult());
            }
            catch (SAXException e) {
                throw new SVGException(String.format("Could not create result for stop [%s]", child));
            }
        }
    }

    @Override
    protected final TPaint createResult(SVGCssStyle ownStyle, Transform ownTransform) throws SVGException {
        throw new UnsupportedOperationException("May not create gradient with out an element");
    }

    public abstract TPaint createResult(SVGAttributeTypeRectangle.SVGTypeRectangle var1, Transform var2) throws SVGException;
}

