/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.core.elements;

import de.saxsys.svgfx.core.SVGDocumentDataProvider;
import de.saxsys.svgfx.core.SVGException;
import de.saxsys.svgfx.core.attributes.CoreAttributeMapper;
import de.saxsys.svgfx.core.attributes.PresentationAttributeMapper;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeHolder;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeType;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeTypeString;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeTypeTransform;
import de.saxsys.svgfx.core.css.SVGCssStyle;
import de.saxsys.svgfx.core.utils.SVGUtil;
import de.saxsys.svgfx.core.utils.StringUtil;
import de.saxsys.svgfx.css.definitions.Constants;
import de.saxsys.svgfx.xml.core.ElementBase;
import java.util.Map;
import java.util.Optional;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class SVGElementBase<TResult>
extends ElementBase<SVGAttributeType, SVGAttributeHolder, SVGDocumentDataProvider, TResult, SVGElementBase<?>> {
    private TResult result;

    protected SVGElementBase(String name, Attributes attributes, SVGDocumentDataProvider dataProvider) throws IllegalArgumentException {
        super(name, attributes, dataProvider, new SVGAttributeHolder(dataProvider));
    }

    @Override
    public final TResult getResult() throws SAXException {
        if (this.result == null) {
            try {
                this.result = this.createAndInitializeResult(null, null);
            }
            catch (SVGException e) {
                throw new SAXException(e);
            }
        }
        return this.result;
    }

    @Override
    public void startProcessing() throws SAXException {
        try {
            this.storeElementInDocumentDataProvider();
        }
        catch (SVGException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void endProcessing() throws SAXException {
    }

    public final TResult createAndInitializeResult(SVGCssStyle parentStyle, Transform parentTransform) throws SVGException {
        SVGCssStyle combinedStyle = this.getStyleAndResolveInheritance(parentStyle);
        Transform combinedTransform = this.combineTransform(parentTransform);
        TResult result = this.createResult(combinedStyle, combinedTransform);
        this.initializeResult(result, combinedStyle, combinedTransform);
        return result;
    }

    protected final Optional<Transform> getTransformation() throws SVGException {
        Optional<SVGAttributeTypeTransform> transform = ((SVGAttributeHolder)this.getAttributeHolder()).getAttribute(CoreAttributeMapper.TRANSFORM.getName(), SVGAttributeTypeTransform.class);
        if (transform.isPresent()) {
            return Optional.of(transform.get().getValue());
        }
        return Optional.empty();
    }

    private void storeElementInDocumentDataProvider() throws SVGException {
        Optional<SVGAttributeTypeString> id = ((SVGAttributeHolder)this.getAttributeHolder()).getAttribute(CoreAttributeMapper.ID.getName(), SVGAttributeTypeString.class);
        if (id.isPresent()) {
            ((SVGDocumentDataProvider)this.getDocumentDataProvider()).storeData((String)id.get().getValue(), this);
        }
    }

    private Transform combineTransform(Transform otherTransform) throws SVGException {
        Optional<Transform> transform = this.getTransformation();
        if (transform.isPresent() && otherTransform != null) {
            return otherTransform.createConcatenation(transform.get());
        }
        if (transform.isPresent()) {
            return transform.get();
        }
        if (otherTransform != null) {
            return otherTransform;
        }
        return new Translate();
    }

    private SVGCssStyle getStyleAndResolveInheritance(SVGCssStyle otherStyle) throws SVGException {
        SVGCssStyle style = this.getCombinedStyle();
        if (otherStyle != null) {
            this.combineStylesAndResolveInheritance(style, otherStyle);
        }
        this.cleanStyleBeforeUsing(style);
        return style;
    }

    private void cleanStyleBeforeUsing(SVGCssStyle style) throws SVGException {
        Optional<SVGAttributeTypeString> id = ((SVGAttributeHolder)this.getAttributeHolder()).getAttribute(CoreAttributeMapper.ID.getName(), SVGAttributeTypeString.class);
        if (!id.isPresent()) {
            return;
        }
        Optional<SVGAttributeTypeString> clipPath = ((SVGAttributeHolder)style.getAttributeHolder()).getAttribute(PresentationAttributeMapper.CLIP_PATH.getName(), SVGAttributeTypeString.class);
        if (!clipPath.isPresent()) {
            return;
        }
        String clipPathReference = SVGUtil.stripIRIIdentifiers((String)clipPath.get().getValue());
        if (StringUtil.isNotNullOrEmpty(clipPathReference) && clipPathReference.equals(id.get().getValue())) {
            style.getProperties().remove(PresentationAttributeMapper.CLIP_PATH.getName());
        }
    }

    private void combineStylesAndResolveInheritance(SVGCssStyle style, SVGCssStyle otherStyle) {
        if (style == null) {
            throw new IllegalArgumentException("Given style must not be null");
        }
        if (otherStyle == null) {
            throw new IllegalArgumentException("Given otherStyle must not be null");
        }
        style.combineWithStyle(otherStyle);
        for (Map.Entry property : style.getProperties().entrySet()) {
            if (!((SVGAttributeType)property.getValue()).getIsInherited()) continue;
            Optional otherProperty = ((SVGAttributeHolder)otherStyle.getAttributeHolder()).getAttribute(property.getKey());
            if (otherProperty.isPresent()) {
                ((SVGAttributeType)property.getValue()).setText(((SVGAttributeType)otherProperty.get()).getText());
                continue;
            }
            ((SVGAttributeType)property.getValue()).useDefaultValue();
        }
    }

    private SVGCssStyle getCombinedStyle() throws SVGException {
        SVGCssStyle referencedStyle;
        SVGCssStyle style = this.getPresentationCssStyle();
        SVGCssStyle ownStyle = this.getOwnStyle();
        if (ownStyle != null) {
            if (style == null) {
                style = ownStyle;
            } else {
                style.combineWithStyle(ownStyle);
            }
        }
        if ((referencedStyle = this.getReferencedStyle()) != null) {
            if (style == null) {
                style = referencedStyle;
            } else {
                style.combineWithStyle(referencedStyle);
            }
        }
        if (style == null) {
            style = new SVGCssStyle((SVGDocumentDataProvider)this.getDocumentDataProvider());
        }
        return style;
    }

    private SVGCssStyle getOwnStyle() throws SVGException {
        Optional<SVGAttributeTypeString> style = ((SVGAttributeHolder)this.getAttributeHolder()).getAttribute(CoreAttributeMapper.STYLE.getName(), SVGAttributeTypeString.class);
        if (style.isPresent()) {
            String attribute = (String)style.get().getValue();
            SVGCssStyle ownStyle = new SVGCssStyle((SVGDocumentDataProvider)this.getDocumentDataProvider());
            String cssText = String.format("ownStyle%s%s%s%s", Character.valueOf('{'), attribute, attribute.endsWith(Constants.PROPERTY_END_STRING) ? "" : Character.valueOf(';'), Character.valueOf('}'));
            try {
                ownStyle.parseCssText(cssText);
            }
            catch (IllegalStateException e) {
                throw new SVGException(String.format("Created css text [%s] could not be parsed", cssText), e);
            }
            return ownStyle;
        }
        return null;
    }

    private SVGCssStyle getReferencedStyle() throws SVGException {
        Optional<SVGAttributeTypeString> className = ((SVGAttributeHolder)this.getAttributeHolder()).getAttribute(CoreAttributeMapper.CLASS.getName(), SVGAttributeTypeString.class);
        if (className.isPresent()) {
            String reference = (String)className.get().getValue();
            return ((SVGDocumentDataProvider)this.getDocumentDataProvider()).getUnmodifiableStyles().stream().filter(data -> data.getName().endsWith(reference)).findFirst().orElseThrow(() -> new SVGException(String.format("Given style reference [%s] was not found", reference)));
        }
        return null;
    }

    private SVGCssStyle getPresentationCssStyle() throws SVGException {
        SVGCssStyle result = null;
        StringBuilder cssText = new StringBuilder();
        for (PresentationAttributeMapper attributeMapper : PresentationAttributeMapper.VALUES) {
            ((SVGAttributeHolder)this.getAttributeHolder()).getAttribute(attributeMapper.getName()).ifPresent(attribute -> {
                String data = attribute.getText();
                if (StringUtil.isNotNullOrEmpty(data)) {
                    if (cssText.length() == 0) {
                        cssText.append("presentationStyle{");
                    }
                    cssText.append(String.format("%s%s%s%s", attributeMapper.getName(), Character.valueOf(':'), data, Character.valueOf(';')));
                }
            });
        }
        if (cssText.length() > 0) {
            cssText.append('}');
            result = new SVGCssStyle((SVGDocumentDataProvider)this.getDocumentDataProvider());
            try {
                result.parseCssText(cssText.toString());
            }
            catch (IllegalStateException e) {
                throw new SVGException(String.format("Css text [%s] could not be parsed", cssText), e);
            }
        }
        return result;
    }

    protected abstract TResult createResult(SVGCssStyle var1, Transform var2) throws SVGException;

    protected abstract void initializeResult(TResult var1, SVGCssStyle var2, Transform var3) throws SVGException;
}

