/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.core.attributes.type;

import de.saxsys.svgfx.core.SVGDocumentDataProvider;
import de.saxsys.svgfx.core.SVGException;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeType;
import de.saxsys.svgfx.core.definitions.Constants;
import de.saxsys.svgfx.core.definitions.enumerations.Matrix;
import de.saxsys.svgfx.core.utils.StringUtil;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Shear;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import javafx.util.Pair;

public class SVGAttributeTypeTransform
extends SVGAttributeType<Transform, Void> {
    private static final char CLOSING_BRACE = ')';
    public static final Transform DEFAULT_VALUE = null;

    public SVGAttributeTypeTransform(SVGDocumentDataProvider dataProvider) {
        super(DEFAULT_VALUE, dataProvider);
    }

    @Override
    protected Pair<Transform, Void> getValueAndUnit(String text) throws SVGException {
        return new Pair((Object)this.getTransform(text), null);
    }

    private Transform getTransform(String data) throws SVGException {
        if (StringUtil.isNullOrEmpty(data)) {
            return null;
        }
        Transform result = null;
        EnumSet<Matrix> allMatrices = EnumSet.allOf(Matrix.class);
        allMatrices.remove((Object)Matrix.NONE);
        block0: for (int i = 0; i < data.length(); ++i) {
            for (Matrix matrix : allMatrices) {
                if (!data.startsWith(matrix.getName(), i)) continue;
                int start = i + matrix.getName().length() + 1;
                i = data.indexOf(41, start);
                Transform transform = this.getTransform(matrix, data.substring(start, i));
                if (result == null) {
                    result = transform;
                    continue block0;
                }
                result = result.createConcatenation(transform);
                continue block0;
            }
        }
        return result;
    }

    private Transform getTransform(Matrix matrix, String data) throws SVGException {
        Shear result;
        if (StringUtil.isNullOrEmpty(data)) {
            throw new IllegalArgumentException("Given data must not be null or empty");
        }
        if (matrix == Matrix.NONE) {
            throw new IllegalArgumentException("Given matrix must not be NONE");
        }
        String actualData = data;
        if (actualData.charAt(0) == '(') {
            actualData = actualData.substring(1);
        }
        if (actualData.charAt(actualData.length() - 1) == ')') {
            actualData = actualData.substring(0, actualData.length());
        }
        List<String> values = StringUtil.splitByDelimiters(actualData, Arrays.asList(Character.valueOf(Constants.WHITESPACE), Character.valueOf(Constants.COMMA)), StringUtil::isNotNullOrEmptyAfterTrim);
        switch (matrix) {
            case MATRIX: {
                if (values.size() != 6) {
                    throw new SVGException(String.format("Given number of values does not match for matrix [%s] data is [%s]. Expected 6 values but got %d", matrix.getName(), actualData, values.size()));
                }
                try {
                    result = new Affine(Double.parseDouble(values.get(0).trim()), Double.parseDouble(values.get(2).trim()), Double.parseDouble(values.get(4).trim()), Double.parseDouble(values.get(1).trim()), Double.parseDouble(values.get(3).trim()), Double.parseDouble(values.get(5).trim()));
                    break;
                }
                catch (NumberFormatException e) {
                    throw new SVGException(String.format("Any value in the matrix [%s] does not represent a valid number, data is [%s]", matrix.getName(), actualData), e);
                }
            }
            case TRANSLATE: 
            case SCALE: {
                if (values.size() != 1 && values.size() != 2) {
                    throw new SVGException(String.format("Given number of values does not match for matrix [%s] data is [%s]. Expected 1 or 2 values but got %d", matrix.getName(), actualData, values.size()));
                }
                try {
                    double y;
                    double x = Double.parseDouble(values.get(0).trim());
                    double d = y = values.size() == 2 ? Double.parseDouble(values.get(1).trim()) : x;
                    if (matrix == Matrix.TRANSLATE) {
                        result = new Translate(x, y);
                        break;
                    }
                    result = new Scale(x, y);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new SVGException(String.format("Any value in the matrix [%s] does not represent a valid number, data is [%s]", matrix.getName(), actualData), e);
                }
            }
            case ROTATE: {
                if (values.size() != 1 && values.size() != 3) {
                    throw new SVGException(String.format("Given number of values does not match for matrix [%s] data is [%s]. Expected 1 or 3 values but got %d", matrix.getName(), actualData, values.size()));
                }
                try {
                    double x = values.size() == 3 ? Double.parseDouble(values.get(1).trim()) : 0.0;
                    double y = values.size() == 3 ? Double.parseDouble(values.get(2).trim()) : 0.0;
                    result = new Rotate(Double.parseDouble(values.get(0).trim()), x, y);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new SVGException(String.format("Any value in the matrix [%s] does not represent a valid number, data is [%s]", matrix.getName(), actualData), e);
                }
            }
            default: {
                double shearing;
                if (values.size() != 1) {
                    throw new SVGException(String.format("Given number of values does not match for matrix [%s] data is [%s]. Expected 1 value but got %d", matrix.getName(), actualData, values.size()));
                }
                try {
                    shearing = Double.parseDouble(values.get(0).trim());
                }
                catch (NumberFormatException e) {
                    throw new SVGException(String.format("Any value in the matrix [%s] does not represent a valid number, data is [%s]", matrix.getName(), actualData), e);
                }
                result = matrix == Matrix.SKEW_X ? new Shear(shearing, 0.0) : new Shear(0.0, shearing);
            }
        }
        return result;
    }
}

