/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.core.attributes.type;

import de.saxsys.svgfx.core.SVGDocumentDataProvider;
import de.saxsys.svgfx.core.SVGException;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeType;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeTypePoint;
import de.saxsys.svgfx.core.definitions.Constants;
import de.saxsys.svgfx.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.util.Pair;

public class SVGAttributeTypePoints
extends SVGAttributeType<List<SVGAttributeTypePoint>, Void> {
    public static final List<SVGAttributeTypePoint> DEFAULT_VALUE = new ArrayList<SVGAttributeTypePoint>();

    public SVGAttributeTypePoints(SVGDocumentDataProvider dataProvider) {
        super(DEFAULT_VALUE, dataProvider);
    }

    @Override
    protected Pair<List<SVGAttributeTypePoint>, Void> getValueAndUnit(String cssText) throws SVGException {
        ArrayList<SVGAttributeTypePoint> actualPoints = new ArrayList<SVGAttributeTypePoint>();
        if (StringUtil.isNotNullOrEmpty(cssText)) {
            List<String> values = StringUtil.splitByDelimiters(cssText, Arrays.asList(Character.valueOf(Constants.WHITESPACE), Character.valueOf(Constants.COMMA)), StringUtil::isNotNullOrEmptyAfterTrim);
            if (values.size() % 2 != 0) {
                throw new SVGException(String.format("Css text [%s] must have an even number of points", cssText));
            }
            for (int i = 0; i < values.size(); i += 2) {
                SVGAttributeTypePoint actualPoint = new SVGAttributeTypePoint(this.getDocumentDataProvider());
                actualPoint.setText(String.format("%s%s%s", values.get(i), Character.valueOf(Constants.COMMA), values.get(i + 1)));
                actualPoints.add(actualPoint);
            }
        }
        return new Pair(actualPoints, null);
    }
}

