/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.core.attributes.type;

import de.saxsys.svgfx.core.SVGDocumentDataProvider;
import de.saxsys.svgfx.core.SVGException;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeType;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeTypeLength;
import de.saxsys.svgfx.core.definitions.Constants;
import de.saxsys.svgfx.core.utils.StringUtil;
import java.util.Arrays;
import java.util.List;
import javafx.util.Pair;

public class SVGAttributeTypePoint
extends SVGAttributeType<SVGTypePoint, Void> {
    public static final SVGTypePoint DEFAULT_VALUE = null;

    public SVGAttributeTypePoint(SVGDocumentDataProvider dataProvider) {
        super(DEFAULT_VALUE, dataProvider);
    }

    @Override
    protected Pair<SVGTypePoint, Void> getValueAndUnit(String cssText) throws SVGException {
        List<String> pointSplit = StringUtil.splitByDelimiters(cssText, Arrays.asList(Character.valueOf(Constants.COMMA), Character.valueOf(Constants.WHITESPACE)), StringUtil::isNotNullOrEmptyAfterTrim);
        if (pointSplit.size() != 2) {
            throw new SVGException(String.format("Css text [%s] does not represent a valid point format", cssText));
        }
        SVGTypePoint point = new SVGTypePoint(this.getDocumentDataProvider());
        point.getX().setText(pointSplit.get(0).trim());
        point.getY().setText(pointSplit.get(1).trim());
        return new Pair((Object)point, null);
    }

    public static class SVGTypePoint {
        private final SVGAttributeTypeLength x;
        private final SVGAttributeTypeLength y;

        public SVGTypePoint(SVGDocumentDataProvider dataProvider) {
            this.x = new SVGAttributeTypeLength(dataProvider);
            this.y = new SVGAttributeTypeLength(dataProvider);
        }

        public final SVGAttributeTypeLength getX() {
            return this.x;
        }

        public final SVGAttributeTypeLength getY() {
            return this.y;
        }
    }
}

