/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.core.attributes.type;

import de.saxsys.svgfx.core.SVGDocumentDataProvider;
import de.saxsys.svgfx.core.SVGException;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeType;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeTypeRectangle;
import de.saxsys.svgfx.core.elements.SVGGradientBase;
import de.saxsys.svgfx.core.interfaces.ThrowableSupplier;
import de.saxsys.svgfx.core.utils.SVGUtil;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.transform.Transform;
import javafx.util.Pair;

public class SVGAttributeTypePaint
extends SVGAttributeType<Paint, Void> {
    private static final String CURRENT_COLOR = "currentColor";
    public static final Paint DEFAULT_VALUE = Color.BLACK;
    private boolean isCurrentColor;

    public SVGAttributeTypePaint(SVGDocumentDataProvider dataProvider) {
        super(DEFAULT_VALUE, dataProvider);
    }

    public boolean getIsCurrentColor() throws SVGException {
        this.getValueAndUnit();
        return this.isCurrentColor;
    }

    @Override
    public Pair<Paint, Void> getValueAndUnit(String text) throws SVGException {
        this.isCurrentColor = CURRENT_COLOR.equals(text);
        if (this.isCurrentColor) {
            return new Pair(null, null);
        }
        try {
            return new Pair((Object)Color.web((String)text), null);
        }
        catch (Exception e) {
            throw new SVGException(String.format("Css text [%s] is not a valid web color", text), e);
        }
    }

    public Paint getValue(ThrowableSupplier<SVGAttributeTypeRectangle.SVGTypeRectangle, SVGException> boundingBox, Transform transform) throws SVGException {
        if (this.getText().startsWith("url(#")) {
            return SVGUtil.resolveIRI(this.getText(), this.getDocumentDataProvider(), SVGGradientBase.class).createResult(boundingBox.getOrFail(), transform);
        }
        return (Paint)this.getValue();
    }
}

