/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.core.attributes.type;

import de.saxsys.svgfx.core.SVGDocumentDataProvider;
import de.saxsys.svgfx.core.SVGException;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeType;
import java.util.EnumSet;
import javafx.util.Pair;

public class SVGAttributeTypeLength
extends SVGAttributeType<Double, Unit> {
    public static final double DEFAULT_VALUE = 0.0;

    public SVGAttributeTypeLength(SVGDocumentDataProvider dataProvider) {
        super(0.0, dataProvider);
    }

    @Override
    protected Pair<Double, Unit> getValueAndUnit(String cssText) throws SVGException {
        Unit usedUnit = Unit.NONE;
        for (Unit unit : EnumSet.complementOf(EnumSet.of(Unit.NONE))) {
            if (!cssText.endsWith(unit.getName())) continue;
            usedUnit = unit;
            break;
        }
        try {
            return new Pair((Object)Double.parseDouble(cssText.substring(0, cssText.length() - usedUnit.getName().length()).replaceAll(",", ".")), (Object)usedUnit);
        }
        catch (NumberFormatException e) {
            throw new SVGException(String.format("Css text [%s] does not represent valid number", cssText), e);
        }
    }

    public static enum Unit {
        NONE(""),
        RELATIVE_SELF("em"),
        RELATIVE_HEIGHT("ex"),
        PIXEL("px"),
        INCH("in"),
        CENTIMETER("cm"),
        MILLIMETER("mm"),
        POINT("pt"),
        PICAS("pc"),
        PERCENT("%");

        private final String name;

        private Unit(String name) {
            this.name = name;
        }

        public final String getName() {
            return this.name;
        }
    }
}

