/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.core.attributes.type;

import de.saxsys.svgfx.core.SVGDocumentDataProvider;
import de.saxsys.svgfx.core.SVGException;
import de.saxsys.svgfx.xml.core.AttributeWrapper;
import java.util.Objects;
import javafx.util.Pair;

public abstract class SVGAttributeType<TValue, TUnit>
extends AttributeWrapper {
    private static String INHERIT_INDICATOR = "inherit";
    private static String NONE_INDICATOR = "none";
    private boolean isInherited;
    private boolean isNone;
    private final SVGDocumentDataProvider dataProvider;
    private final TValue defaultValue;
    private Pair<TValue, TUnit> valueAndUnit;

    public SVGAttributeType(TValue defaultValue, SVGDocumentDataProvider dataProvider) {
        this.defaultValue = defaultValue;
        this.dataProvider = dataProvider;
    }

    public final SVGDocumentDataProvider getDocumentDataProvider() {
        return this.dataProvider;
    }

    public final boolean getIsInherited() {
        return this.isInherited;
    }

    public final boolean getIsNone() {
        return this.isNone;
    }

    public final TValue getValue() throws SVGException {
        this.initializeValueAndUnit();
        return (TValue)this.valueAndUnit.getKey();
    }

    public final TUnit getUnit() throws SVGException {
        this.initializeValueAndUnit();
        return (TUnit)this.valueAndUnit.getValue();
    }

    public boolean hasUnit(TUnit unit) throws SVGException {
        return Objects.equals(this.getUnit(), unit);
    }

    public final Pair<TValue, TUnit> getValueAndUnit() throws SVGException {
        this.initializeValueAndUnit();
        return this.valueAndUnit;
    }

    public final void useDefaultValue() {
        this.valueAndUnit = new Pair(this.defaultValue, null);
    }

    @Override
    public final void setText(String text) {
        super.setText(text);
        this.isInherited = INHERIT_INDICATOR.equals(text);
        this.isNone = NONE_INDICATOR.equals(text);
        this.valueAndUnit = null;
    }

    private void initializeValueAndUnit() throws SVGException {
        if (this.valueAndUnit == null) {
            this.valueAndUnit = !this.isInherited && !this.isNone ? this.getValueAndUnit(this.getText()) : new Pair(null, null);
        }
    }

    protected abstract Pair<TValue, TUnit> getValueAndUnit(String var1) throws SVGException;
}

