/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.core.attributes.type;

import de.saxsys.svgfx.core.SVGDocumentDataProvider;
import de.saxsys.svgfx.core.SVGException;
import de.saxsys.svgfx.core.attributes.CoreAttributeMapper;
import de.saxsys.svgfx.core.attributes.PresentationAttributeMapper;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeType;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeTypeString;
import de.saxsys.svgfx.xml.core.AttributeHolder;
import java.util.Optional;

public class SVGAttributeHolder
extends AttributeHolder<SVGAttributeType> {
    private SVGDocumentDataProvider dataProvider;

    public SVGAttributeHolder(SVGDocumentDataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    public final <TValue> TValue getAttributeValue(String name, Class<TValue> clazz, TValue defaultValue) throws SVGException {
        Optional attribute = this.getAttribute(name);
        if (!attribute.isPresent()) {
            return defaultValue;
        }
        return clazz.cast(((SVGAttributeType)attribute.get()).getValue());
    }

    @Override
    public SVGAttributeType createAttributeType(String name) {
        for (PresentationAttributeMapper presentationAttributeMapper : PresentationAttributeMapper.VALUES) {
            if (!presentationAttributeMapper.getName().equals(name)) continue;
            return presentationAttributeMapper.getContentTypeCreator().apply(this.dataProvider);
        }
        for (CoreAttributeMapper coreAttributeMapper : CoreAttributeMapper.VALUES) {
            if (!coreAttributeMapper.getName().equals(name)) continue;
            return coreAttributeMapper.getContentTypeCreator().apply(this.dataProvider);
        }
        return new SVGAttributeTypeString(this.dataProvider);
    }
}

