/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.core;

import de.saxsys.svgfx.core.SVGDocumentDataProvider;
import de.saxsys.svgfx.core.css.SVGCssStyle;
import de.saxsys.svgfx.core.elements.SVGClipPath;
import de.saxsys.svgfx.core.elements.SVGDefinitions;
import de.saxsys.svgfx.core.elements.SVGElementBase;
import de.saxsys.svgfx.core.elements.SVGElementFactory;
import de.saxsys.svgfx.core.elements.SVGGradientBase;
import de.saxsys.svgfx.core.elements.SVGStop;
import de.saxsys.svgfx.core.path.CommandParser;
import de.saxsys.svgfx.core.path.commands.CommandFactory;
import de.saxsys.svgfx.xml.core.SAXParser;
import javafx.scene.Group;
import javafx.scene.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SVGParser
extends SAXParser<Group, SVGDocumentDataProvider, SVGElementFactory, SVGElementBase<?>>
implements EntityResolver {
    private static final CommandFactory COMMAND_FACTORY = new CommandFactory();
    private static final CommandParser COMMAND_PARSER = new CommandParser(COMMAND_FACTORY);
    private static final SVGElementFactory SVG_ELEMENT_FACTORY = new SVGElementFactory(COMMAND_PARSER);

    public SVGParser() {
        super(SVG_ELEMENT_FACTORY, new SVGDocumentDataProvider());
    }

    @Override
    protected void configureReader(XMLReader reader) throws SAXException {
    }

    @Override
    protected void enteringDocument() {
    }

    @Override
    protected Group leavingDocument(SVGElementBase<?> element) throws SAXException {
        Group result = new Group();
        if (element != null) {
            for (SVGElementBase child : element.getUnmodifiableChildren()) {
                if (!this.canConsumeElement(element)) continue;
                result.getChildren().add((Object)((Node)child.getResult()));
            }
        }
        return result;
    }

    private boolean canConsumeElement(SVGElementBase element) {
        return !SVGClipPath.class.isAssignableFrom(element.getClass()) && !SVGDefinitions.class.isAssignableFrom(element.getClass()) && !SVGGradientBase.class.isAssignableFrom(element.getClass()) && !SVGCssStyle.class.isAssignableFrom(element.getClass()) && !SVGStop.class.isAssignableFrom(element.getClass());
    }
}

