/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.core;

import de.saxsys.svgfx.core.SVGException;
import de.saxsys.svgfx.core.css.SVGCssStyle;
import de.saxsys.svgfx.core.elements.SVGElementBase;
import de.saxsys.svgfx.core.utils.StringUtil;
import de.saxsys.svgfx.xml.core.IDocumentDataProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class SVGDocumentDataProvider
implements IDocumentDataProvider {
    private final Map<String, SVGElementBase> data = new HashMap<String, SVGElementBase>();
    private final Set<SVGCssStyle> styles = new HashSet<SVGCssStyle>();

    public final Map<String, SVGElementBase> getUnmodifiableData() {
        return Collections.unmodifiableMap(this.data);
    }

    public final Set<SVGCssStyle> getUnmodifiableStyles() {
        return Collections.unmodifiableSet(this.styles);
    }

    public boolean addStyle(SVGCssStyle style) {
        return this.styles.add(style);
    }

    public boolean addStyles(Collection<SVGCssStyle> styles) {
        return this.styles.addAll(styles);
    }

    public final void storeData(String key, SVGElementBase data) {
        if (StringUtil.isNullOrEmpty(key)) {
            throw new IllegalArgumentException("given key must not be null or empty");
        }
        if (data == null) {
            throw new IllegalArgumentException("given data must not be null");
        }
        this.data.put(key, data);
    }

    public final <TData extends SVGElementBase> Optional<TData> getData(String key, Class<TData> clazz) throws SVGException {
        if (clazz == null) {
            throw new IllegalArgumentException("given class must not be null or empty");
        }
        if (StringUtil.isNullOrEmpty(key)) {
            throw new IllegalArgumentException("given key must not be null or empty");
        }
        SVGElementBase data = this.data.get(key);
        if (data != null && clazz.isAssignableFrom(data.getClass())) {
            return Optional.of(clazz.cast(data));
        }
        return Optional.empty();
    }

    @Override
    public final void clear() {
        this.data.clear();
        this.styles.clear();
    }
}

