/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.xml.core;

import de.saxsys.svgfx.xml.core.ElementBase;
import de.saxsys.svgfx.xml.core.IDocumentDataProvider;
import de.saxsys.svgfx.xml.core.IElementFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyProperty;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public abstract class SAXParser<TResult, TDocumentDataProvider extends IDocumentDataProvider, TElementFactory extends IElementFactory<TDocumentDataProvider, TElement>, TElement extends ElementBase<?, ?, TDocumentDataProvider, ?, TElement, TElement>>
extends DefaultHandler
implements EntityResolver {
    private static final InputSource FAKE_ENTITY_SOURCE = new InputSource(new StringReader(""));
    private static final String FEATURE_VALIDATION = "http://xml.org/sax/features/validation";
    private final TElementFactory elementFactory;
    private final TDocumentDataProvider documentDataProvider;
    private final ReadOnlyObjectWrapper<State> state = new ReadOnlyObjectWrapper((Object)State.IDLE);
    private TResult result;
    private long attemptedParses;
    private long successfulParses;
    private TElement currentElement;

    public SAXParser(TElementFactory elementFactory, TDocumentDataProvider documentDataProvider) throws IllegalArgumentException {
        if (elementFactory == null) {
            throw new IllegalArgumentException("given elementcreator must not be null");
        }
        if (documentDataProvider == null) {
            throw new IllegalArgumentException("given documentDataProvider must not be null");
        }
        this.elementFactory = elementFactory;
        this.documentDataProvider = documentDataProvider;
        this.result = null;
    }

    public final TResult getResult() {
        return this.result;
    }

    public final long getAttemptedParses() {
        return this.attemptedParses;
    }

    public final long getSuccessfulParses() {
        return this.successfulParses;
    }

    public final State getState() {
        return (State)((Object)this.state.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(State state) {
        ReadOnlyObjectWrapper<State> readOnlyObjectWrapper = this.state;
        synchronized (readOnlyObjectWrapper) {
            this.state.set((Object)state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isBusy() {
        ReadOnlyObjectWrapper<State> readOnlyObjectWrapper = this.state;
        synchronized (readOnlyObjectWrapper) {
            return this.state.get() != State.IDLE && this.state.get() != State.FINISHED;
        }
    }

    public final ReadOnlyProperty<State> stateProperty() {
        return this.state.getReadOnlyProperty();
    }

    protected abstract void configureReader(XMLReader var1) throws SAXException;

    protected abstract void enteringDocument() throws SAXException;

    protected abstract TResult leavingDocument(TElement var1) throws SAXException;

    public final void clear() {
        if (this.isBusy()) {
            throw new IllegalStateException("Can not clean while parser is still working");
        }
        this.documentDataProvider.clear();
    }

    public final void parse(String path) throws SAXParseException, IllegalArgumentException, IllegalStateException, IOException {
        this.parse(new File(path));
    }

    public final void parse(File file) throws SAXParseException, IllegalArgumentException, IllegalStateException, IOException {
        if (file == null) {
            throw new IllegalArgumentException("given file must not be null");
        }
        FileInputStream stream = new FileInputStream(file);
        this.parse(new InputSource(stream));
        ((InputStream)stream).close();
    }

    public final void parse(InputSource data) throws SAXParseException, IllegalArgumentException, IllegalStateException {
        if (data == null) {
            throw new IllegalArgumentException("given data must not be null");
        }
        if (this.isBusy()) {
            throw new IllegalStateException("Can not attempt to parse while the parser is still working");
        }
        try {
            this.setState(State.PREPARING);
            this.documentDataProvider.clear();
            ++this.attemptedParses;
            XMLReader reader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            this.configureReader(reader);
            reader.setContentHandler(this);
            reader.setEntityResolver(this);
            reader.setFeature(FEATURE_VALIDATION, false);
            reader.parse(data);
            ++this.successfulParses;
        }
        catch (Exception e) {
            throw new SAXParseException(null, null, e);
        }
    }

    @Override
    public final void startDocument() throws SAXException {
        this.currentElement = null;
        this.enteringDocument();
        this.setState(State.STARTING);
    }

    @Override
    public final void endDocument() throws SAXException {
        this.result = this.leavingDocument(this.currentElement);
        this.setState(State.FINISHED);
        this.currentElement = null;
    }

    @Override
    public final void startElement(String namespaceURI, String localName, String qName, Attributes attributes) throws SAXException {
        this.setState(State.PARSING_ENTERING_ELEMENT);
        TElement nextElement = this.elementFactory.createElement(qName, attributes, this.currentElement, this.documentDataProvider);
        if (nextElement != null) {
            if (this.currentElement != null && ((ElementBase)nextElement).rememberElement()) {
                ((ElementBase)this.currentElement).addChild(nextElement);
            }
            this.currentElement = nextElement;
            ((ElementBase)this.currentElement).startProcessing();
        }
        this.setState(State.PARSING_ENTERING_ELEMENT_FINISHED);
    }

    @Override
    public final void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.setState(State.PARSING_LEAVING_ELEMENT);
        if (this.currentElement != null && ((ElementBase)this.currentElement).getName().equals(qName)) {
            ((ElementBase)this.currentElement).endProcessing();
            if (((ElementBase)this.currentElement).getParent() != null) {
                this.currentElement = ((ElementBase)this.currentElement).getParent();
            }
        }
        this.setState(State.PARSING_LEAVING_ELEMENT_FINISHED);
    }

    @Override
    public final void characters(char[] ch, int start, int length) throws SAXException {
        this.setState(State.PARSING_ENTERING_ELEMENT_CHARACTERS);
        if (this.currentElement != null) {
            ((ElementBase)this.currentElement).processCharacterData(ch, start, length);
        }
        this.setState(State.PARSING_ENTERING_ELEMENT_CHARACTERS_FINISHED);
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        return FAKE_ENTITY_SOURCE;
    }

    public static enum State {
        IDLE,
        PREPARING,
        STARTING,
        PARSING_ENTERING_ELEMENT,
        PARSING_ENTERING_ELEMENT_FINISHED,
        PARSING_ENTERING_ELEMENT_CHARACTERS,
        PARSING_ENTERING_ELEMENT_CHARACTERS_FINISHED,
        PARSING_LEAVING_ELEMENT,
        PARSING_LEAVING_ELEMENT_FINISHED,
        FINISHED;

    }
}

