/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.core.utils;

import de.saxsys.svgfx.core.SVGException;
import java.util.ArrayList;
import java.util.List;

public final class StringUtil {
    private StringUtil() {
    }

    public static String replaceLast(String source, char toReplace, char toUse) {
        return StringUtil.replaceLast(source, String.valueOf(toReplace), String.valueOf(toUse));
    }

    public static String replaceLast(String source, String toReplace, String toUse) {
        if (source == null) {
            return null;
        }
        int lastIndex = source.lastIndexOf(toReplace);
        if (lastIndex < 0) {
            return source;
        }
        return String.format("%s%s", source.substring(0, lastIndex), source.substring(lastIndex).replaceFirst(toReplace, toUse));
    }

    public static boolean isNullOrEmpty(String data) {
        return data == null || data.isEmpty();
    }

    public static boolean isNotNullOrEmpty(String data) {
        return !StringUtil.isNullOrEmpty(data);
    }

    public static String stripStringIndicators(String data) {
        if (StringUtil.isNullOrEmpty(data)) {
            throw new IllegalArgumentException("given data must not be null or empty");
        }
        return data.substring(data.charAt(0) == '\"' ? 1 : 0, data.charAt(data.length() - 1) == '\"' ? data.length() - 1 : data.length());
    }

    public static List<String> splitByDelimiters(String data, List<Character> delimiters) throws SVGException {
        return StringUtil.splitByDelimiters(data, delimiters, (split, index) -> true);
    }

    public static List<String> splitByDelimiters(String data, List<Character> delimiters, SplitPredicate consumePredicate) throws SVGException {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < data.length(); ++i) {
            boolean isLastCharacter;
            char character = data.charAt(i);
            boolean isDelimiter = delimiters.contains(Character.valueOf(character));
            boolean bl = isLastCharacter = i == data.length() - 1;
            if (isLastCharacter || isDelimiter) {
                if (isLastCharacter && !isDelimiter) {
                    builder.append(character);
                }
                if (builder.length() <= 0 || !consumePredicate.test(builder.toString(), i)) continue;
                result.add(builder.toString());
                builder.setLength(0);
                continue;
            }
            builder.append(character);
        }
        return result;
    }

    @FunctionalInterface
    public static interface SplitPredicate {
        public boolean test(String var1, int var2) throws SVGException;
    }
}

