/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.core.utils;

import java.util.function.Consumer;
import java.util.function.Function;

public final class ConvertUtils {
    public static <TInput, TOutput> void applyData(TInput data, Consumer<TOutput> consumer, Function<TInput, TOutput> converter) {
        ConvertUtils.applyData(data, consumer, converter, null);
    }

    public static <TInput, TOutput> void applyData(TInput data, Consumer<TOutput> consumer, Function<TInput, TOutput> converter, Function<TInput, Boolean> validator) throws IllegalArgumentException {
        if (consumer == null) {
            throw new IllegalArgumentException("given consumer must not be null");
        }
        consumer.accept(ConvertUtils.convert(data, converter, validator));
    }

    public static <TInput, TOutput> TOutput convert(TInput data, Function<TInput, TOutput> converter, Function<TInput, Boolean> validator) throws IllegalArgumentException {
        if (validator != null && !validator.apply(data).booleanValue()) {
            throw new IllegalArgumentException("given data is not valid according to the provided validator");
        }
        return converter.apply(data);
    }

    private ConvertUtils() {
    }
}

