/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.core.elements;

import de.saxsys.svgfx.core.SVGDocumentDataProvider;
import de.saxsys.svgfx.core.SVGException;
import de.saxsys.svgfx.core.attributes.PresentationAttributeMapper;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeHolder;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeTypeDouble;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeTypeLength;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeTypePaint;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeTypeRectangle;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeTypeStrokeDashArray;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeTypeStrokeLineCap;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeTypeStrokeLineJoin;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeTypeStrokeType;
import de.saxsys.svgfx.core.css.SVGCssStyle;
import de.saxsys.svgfx.core.css.StyleSupplier;
import de.saxsys.svgfx.core.elements.SVGElementBase;
import de.saxsys.svgfx.core.elements.SVGNodeBase;
import java.util.ArrayList;
import java.util.Optional;
import javafx.scene.paint.Color;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;
import org.xml.sax.Attributes;

public abstract class SVGShapeBase<TShape extends Shape>
extends SVGNodeBase<TShape> {
    protected SVGShapeBase(String name, Attributes attributes, SVGElementBase<?> parent, SVGDocumentDataProvider dataProvider) {
        super(name, attributes, parent, dataProvider);
    }

    @Override
    protected void initializeResult(TShape shape, StyleSupplier styleSupplier) throws SVGException {
        super.initializeResult(shape, styleSupplier);
        this.applyStyle(shape, styleSupplier);
    }

    private void applyStyle(TShape shape, StyleSupplier styleSupplier) throws SVGException {
        Optional<SVGAttributeTypeDouble> strokeMiterLimit;
        Optional<SVGAttributeTypeStrokeLineCap> strokeLineCap;
        Optional<SVGAttributeTypeStrokeLineJoin> strokeLineJoin;
        Optional<SVGAttributeTypeLength> strokeDashOffset;
        Optional<SVGAttributeTypeStrokeDashArray> strokeDashArray;
        Optional<SVGAttributeTypeLength> strokeWidth;
        Optional<SVGAttributeTypeStrokeType> strokeType;
        Optional<SVGAttributeTypePaint> stroke;
        if (shape == null) {
            throw new SVGException(SVGException.Reason.NULL_ARGUMENT, "Given shape must not be null");
        }
        SVGCssStyle style = styleSupplier.get();
        Optional<SVGAttributeTypePaint> fill = ((SVGAttributeHolder)style.getAttributeHolder()).getAttribute(PresentationAttributeMapper.FILL.getName(), SVGAttributeTypePaint.class);
        if (fill.isPresent()) {
            Paint paint = fill.get().getValue(this);
            Optional<SVGAttributeTypeDouble> opacity = ((SVGAttributeHolder)style.getAttributeHolder()).getAttribute(PresentationAttributeMapper.OPACITY.getName(), SVGAttributeTypeDouble.class);
            if (opacity.isPresent()) {
                paint = this.applyOpacity(paint, (Double)opacity.get().getValue());
            }
            shape.setFill(paint);
        }
        if ((stroke = ((SVGAttributeHolder)style.getAttributeHolder()).getAttribute(PresentationAttributeMapper.STROKE.getName(), SVGAttributeTypePaint.class)).isPresent()) {
            Paint paint = stroke.get().getValue(this);
            Optional<SVGAttributeTypeDouble> opacity = ((SVGAttributeHolder)style.getAttributeHolder()).getAttribute(PresentationAttributeMapper.STROKE_OPACITY.getName(), SVGAttributeTypeDouble.class);
            if (opacity.isPresent()) {
                paint = this.applyOpacity(paint, (Double)opacity.get().getValue());
            }
            shape.setStroke(paint);
        }
        if ((strokeType = ((SVGAttributeHolder)style.getAttributeHolder()).getAttribute(PresentationAttributeMapper.STROKE_TYPE.getName(), SVGAttributeTypeStrokeType.class)).isPresent()) {
            shape.setStrokeType((StrokeType)strokeType.get().getValue());
        }
        if ((strokeWidth = ((SVGAttributeHolder)style.getAttributeHolder()).getAttribute(PresentationAttributeMapper.STROKE_WIDTH.getName(), SVGAttributeTypeLength.class)).isPresent()) {
            shape.setStrokeWidth(((Double)strokeWidth.get().getValue()).doubleValue());
        }
        if ((strokeDashArray = ((SVGAttributeHolder)style.getAttributeHolder()).getAttribute(PresentationAttributeMapper.STROKE_DASHARRAY.getName(), SVGAttributeTypeStrokeDashArray.class)).isPresent()) {
            shape.getStrokeDashArray().clear();
            shape.getStrokeDashArray().addAll(strokeDashArray.get().getDashValues());
        }
        if ((strokeDashOffset = ((SVGAttributeHolder)style.getAttributeHolder()).getAttribute(PresentationAttributeMapper.STROKE_DASHOFFSET.getName(), SVGAttributeTypeLength.class)).isPresent()) {
            shape.setStrokeDashOffset(((Double)strokeDashOffset.get().getValue()).doubleValue());
        }
        if ((strokeLineJoin = ((SVGAttributeHolder)style.getAttributeHolder()).getAttribute(PresentationAttributeMapper.STROKE_LINEJOIN.getName(), SVGAttributeTypeStrokeLineJoin.class)).isPresent()) {
            shape.setStrokeLineJoin((StrokeLineJoin)strokeLineJoin.get().getValue());
        }
        if ((strokeLineCap = ((SVGAttributeHolder)style.getAttributeHolder()).getAttribute(PresentationAttributeMapper.STROKE_LINECAP.getName(), SVGAttributeTypeStrokeLineCap.class)).isPresent()) {
            shape.setStrokeLineCap((StrokeLineCap)strokeLineCap.get().getValue());
        }
        if ((strokeMiterLimit = ((SVGAttributeHolder)style.getAttributeHolder()).getAttribute(PresentationAttributeMapper.STROKE_MITERLIMIT.getName(), SVGAttributeTypeDouble.class)).isPresent()) {
            shape.setStrokeMiterLimit(((Double)strokeMiterLimit.get().getValue()).doubleValue());
        }
    }

    private Paint applyOpacity(Paint paint, double opacity) {
        if (paint instanceof Color) {
            Color color = (Color)paint;
            return new Color(color.getRed(), color.getGreen(), color.getBlue(), opacity);
        }
        if (paint instanceof LinearGradient) {
            LinearGradient gradient = (LinearGradient)paint;
            ArrayList newStops = new ArrayList();
            gradient.getStops().forEach(stop -> newStops.add(new Stop(stop.getOffset(), new Color(stop.getColor().getRed(), stop.getColor().getGreen(), stop.getColor().getBlue(), opacity))));
            return new LinearGradient(gradient.getStartX(), gradient.getStartY(), gradient.getEndX(), gradient.getEndY(), gradient.isProportional(), gradient.getCycleMethod(), newStops);
        }
        if (paint instanceof RadialGradient) {
            RadialGradient gradient = (RadialGradient)paint;
            ArrayList newStops = new ArrayList();
            gradient.getStops().forEach(stop -> newStops.add(new Stop(stop.getOffset(), new Color(stop.getColor().getRed(), stop.getColor().getGreen(), stop.getColor().getBlue(), opacity))));
            return new RadialGradient(gradient.getFocusAngle(), gradient.getFocusDistance(), gradient.getCenterX(), gradient.getCenterY(), gradient.getRadius(), gradient.isProportional(), gradient.getCycleMethod(), newStops);
        }
        return paint;
    }

    public abstract SVGAttributeTypeRectangle.SVGTypeRectangle createBoundingBox() throws SVGException;
}

