/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.core.elements;

import de.saxsys.svgfx.core.SVGDocumentDataProvider;
import de.saxsys.svgfx.core.SVGException;
import de.saxsys.svgfx.core.attributes.CoreAttributeMapper;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeHolder;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeTypeLength;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeTypeRectangle;
import de.saxsys.svgfx.core.css.StyleSupplier;
import de.saxsys.svgfx.core.elements.SVGElementBase;
import de.saxsys.svgfx.core.elements.SVGShapeBase;
import java.util.Optional;
import javafx.scene.shape.Rectangle;
import org.xml.sax.Attributes;

public class SVGRectangle
extends SVGShapeBase<Rectangle> {
    public static final String ELEMENT_NAME = "rect";

    SVGRectangle(String name, Attributes attributes, SVGElementBase<?> parent, SVGDocumentDataProvider dataProvider) {
        super(name, attributes, parent, dataProvider);
    }

    @Override
    protected final Rectangle createResult(StyleSupplier styleSupplier) throws SVGException {
        return new Rectangle(((SVGAttributeHolder)this.getAttributeHolder()).getAttributeValue(CoreAttributeMapper.POSITION_X.getName(), Double.class, 0.0).doubleValue(), ((SVGAttributeHolder)this.getAttributeHolder()).getAttributeValue(CoreAttributeMapper.POSITION_Y.getName(), Double.class, 0.0).doubleValue(), ((Double)((SVGAttributeHolder)this.getAttributeHolder()).getAttributeOrFail(CoreAttributeMapper.WIDTH.getName(), SVGAttributeTypeLength.class).getValue()).doubleValue(), ((Double)((SVGAttributeHolder)this.getAttributeHolder()).getAttributeOrFail(CoreAttributeMapper.HEIGHT.getName(), SVGAttributeTypeLength.class).getValue()).doubleValue());
    }

    @Override
    protected void initializeResult(Rectangle rect, StyleSupplier styleSupplier) throws SVGException {
        Optional<SVGAttributeTypeLength> radiusY;
        super.initializeResult(rect, styleSupplier);
        Optional<SVGAttributeTypeLength> radiusX = ((SVGAttributeHolder)this.getAttributeHolder()).getAttribute(CoreAttributeMapper.RADIUS_X.getName(), SVGAttributeTypeLength.class);
        if (radiusX.isPresent()) {
            rect.setArcWidth((Double)radiusX.get().getValue() * 2.0);
        }
        if ((radiusY = ((SVGAttributeHolder)this.getAttributeHolder()).getAttribute(CoreAttributeMapper.RADIUS_Y.getName(), SVGAttributeTypeLength.class)).isPresent()) {
            rect.setArcHeight((Double)radiusY.get().getValue() * 2.0);
        }
    }

    @Override
    public SVGAttributeTypeRectangle.SVGTypeRectangle createBoundingBox() throws SVGException {
        SVGAttributeTypeLength posX = ((SVGAttributeHolder)this.getAttributeHolder()).getAttributeOrFail(CoreAttributeMapper.POSITION_X.getName(), SVGAttributeTypeLength.class);
        SVGAttributeTypeLength posY = ((SVGAttributeHolder)this.getAttributeHolder()).getAttributeOrFail(CoreAttributeMapper.POSITION_Y.getName(), SVGAttributeTypeLength.class);
        SVGAttributeTypeLength width = ((SVGAttributeHolder)this.getAttributeHolder()).getAttributeOrFail(CoreAttributeMapper.WIDTH.getName(), SVGAttributeTypeLength.class);
        SVGAttributeTypeLength height = ((SVGAttributeHolder)this.getAttributeHolder()).getAttributeOrFail(CoreAttributeMapper.HEIGHT.getName(), SVGAttributeTypeLength.class);
        SVGAttributeTypeRectangle.SVGTypeRectangle result = new SVGAttributeTypeRectangle.SVGTypeRectangle((SVGDocumentDataProvider)this.getDocumentDataProvider());
        result.getMinX().setText(String.format("%f%s", posX.getValue(), ((SVGAttributeTypeLength.Unit)((Object)posX.getUnit())).getName()));
        result.getMinY().setText(String.format("%f%s", posY.getValue(), ((SVGAttributeTypeLength.Unit)((Object)posY.getUnit())).getName()));
        result.getMaxX().setText(String.format("%f%s", (Double)posX.getValue() + (Double)width.getValue(), ((SVGAttributeTypeLength.Unit)((Object)posX.getUnit())).getName()));
        result.getMaxY().setText(String.format("%f%s", (Double)posY.getValue() + (Double)height.getValue(), ((SVGAttributeTypeLength.Unit)((Object)posY.getUnit())).getName()));
        return result;
    }
}

