/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.core.elements;

import de.saxsys.svgfx.core.SVGDocumentDataProvider;
import de.saxsys.svgfx.core.SVGException;
import de.saxsys.svgfx.core.attributes.CoreAttributeMapper;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeHolder;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeTypeCycleMethod;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeTypeRectangle;
import de.saxsys.svgfx.core.css.StyleSupplier;
import de.saxsys.svgfx.core.definitions.Enumerations;
import de.saxsys.svgfx.core.elements.SVGElementBase;
import de.saxsys.svgfx.core.elements.SVGGradientBase;
import de.saxsys.svgfx.core.elements.SVGShapeBase;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import org.xml.sax.Attributes;

public class SVGRadialGradient
extends SVGGradientBase<RadialGradient> {
    public static final String ELEMENT_NAME = "radialGradient";
    private static final Double DEFAULT_RADIUS = 0.5;
    private static final Double DEFAULT_CENTER = 0.5;

    SVGRadialGradient(String name, Attributes attributes, SVGElementBase<SVGDocumentDataProvider> parent, SVGDocumentDataProvider dataProvider) {
        super(name, attributes, parent, dataProvider);
    }

    @Override
    protected final RadialGradient createResult(StyleSupplier styleSupplier) throws SVGException {
        return this.determineResult(null);
    }

    @Override
    public RadialGradient createResult(SVGShapeBase<?> shape) throws SVGException {
        return this.determineResult(shape);
    }

    private RadialGradient determineResult(SVGShapeBase<?> shape) throws SVGException {
        List<Stop> stops = this.getStops();
        if (stops.isEmpty()) {
            throw new SVGException(SVGException.Reason.MISSING_STOPS, "Given radial gradient does not have colors");
        }
        AtomicReference<Double> centerX = new AtomicReference<Double>(((SVGAttributeHolder)this.getAttributeHolder()).getAttributeValue(CoreAttributeMapper.CENTER_X.getName(), Double.class, DEFAULT_CENTER));
        AtomicReference<Double> centerY = new AtomicReference<Double>(((SVGAttributeHolder)this.getAttributeHolder()).getAttributeValue(CoreAttributeMapper.CENTER_Y.getName(), Double.class, DEFAULT_CENTER));
        AtomicReference<Double> focusX = new AtomicReference<Double>(((SVGAttributeHolder)this.getAttributeHolder()).getAttributeValue(CoreAttributeMapper.FOCUS_X.getName(), Double.class, centerX.get()));
        AtomicReference<Double> focusY = new AtomicReference<Double>(((SVGAttributeHolder)this.getAttributeHolder()).getAttributeValue(CoreAttributeMapper.FOCUS_Y.getName(), Double.class, centerY.get()));
        AtomicReference<Double> radius = new AtomicReference<Double>(((SVGAttributeHolder)this.getAttributeHolder()).getAttributeValue(CoreAttributeMapper.RADIUS.getName(), Double.class, DEFAULT_RADIUS));
        Enumerations.GradientUnit gradientUnit = ((SVGAttributeHolder)this.getAttributeHolder()).getAttributeValue(CoreAttributeMapper.GRADIENT_UNITS.getName(), Enumerations.GradientUnit.class, Enumerations.GradientUnit.OBJECT_BOUNDING_BOX);
        if (gradientUnit == Enumerations.GradientUnit.USER_SPACE_ON_USE) {
            if (shape == null) {
                throw new SVGException(SVGException.Reason.MISSING_ELEMENT, "Can not create linear gradient when user space is defined but the requesting shape is missing.");
            }
            this.adjustPosition(centerX, centerY, focusX, focusY, radius, shape);
        }
        double diffX = focusX.get() - centerX.get();
        double diffY = focusY.get() - centerY.get();
        double distance = diffX == 0.0 ? Math.abs(diffY) : (diffY == 0.0 ? Math.abs(diffX) : Math.hypot(diffX, diffY));
        return new RadialGradient(Math.toDegrees(Math.atan2(diffY, diffX)), distance > radius.get() ? 1.0 : distance / radius.get(), centerX.get().doubleValue(), centerY.get().doubleValue(), radius.get().doubleValue(), true, ((SVGAttributeHolder)this.getAttributeHolder()).getAttributeValue(CoreAttributeMapper.SPREAD_METHOD.getName(), CycleMethod.class, SVGAttributeTypeCycleMethod.DEFAULT_VALUE), stops);
    }

    private void adjustPosition(AtomicReference<Double> centerX, AtomicReference<Double> centerY, AtomicReference<Double> focusX, AtomicReference<Double> focusY, AtomicReference<Double> radius, SVGShapeBase<?> shape) throws SVGException {
        SVGAttributeTypeRectangle.SVGTypeRectangle boundingBox = shape.createBoundingBox();
        Double width = (Double)boundingBox.getMaxX().getValue() - (Double)boundingBox.getMinX().getValue();
        Double height = (Double)boundingBox.getMaxY().getValue() - (Double)boundingBox.getMinY().getValue();
        centerX.set(Math.abs((Double)boundingBox.getMinX().getValue() - centerX.get()) / width);
        centerY.set(Math.abs((Double)boundingBox.getMinY().getValue() - centerY.get()) / height);
        focusX.set(Math.abs((Double)boundingBox.getMinX().getValue() - focusX.get()) / width);
        focusY.set(Math.abs((Double)boundingBox.getMinY().getValue() - focusY.get()) / height);
        radius.set(radius.get() / height);
    }
}

