/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.core.elements;

import de.saxsys.svgfx.core.SVGDocumentDataProvider;
import de.saxsys.svgfx.core.SVGException;
import de.saxsys.svgfx.core.attributes.CoreAttributeMapper;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeHolder;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeTypeCycleMethod;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeTypeRectangle;
import de.saxsys.svgfx.core.css.StyleSupplier;
import de.saxsys.svgfx.core.definitions.Enumerations;
import de.saxsys.svgfx.core.elements.SVGElementBase;
import de.saxsys.svgfx.core.elements.SVGGradientBase;
import de.saxsys.svgfx.core.elements.SVGShapeBase;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Stop;
import org.xml.sax.Attributes;

public class SVGLinearGradient
extends SVGGradientBase<LinearGradient> {
    public static final String ELEMENT_NAME = "linearGradient";
    private static final Double DEFAULT_END_X = 1.0;

    SVGLinearGradient(String name, Attributes attributes, SVGElementBase<?> parent, SVGDocumentDataProvider dataProvider) {
        super(name, attributes, parent, dataProvider);
    }

    @Override
    protected final LinearGradient createResult(StyleSupplier styleSupplier) throws SVGException {
        return this.determineResult(null);
    }

    @Override
    public LinearGradient createResult(SVGShapeBase<?> shape) throws SVGException {
        return this.determineResult(shape);
    }

    private LinearGradient determineResult(SVGShapeBase<?> shape) throws SVGException {
        List<Stop> stops = this.getStops();
        if (stops.isEmpty()) {
            throw new SVGException(SVGException.Reason.MISSING_STOPS);
        }
        AtomicReference<Double> startX = new AtomicReference<Double>(((SVGAttributeHolder)this.getAttributeHolder()).getAttributeValue(CoreAttributeMapper.START_X.getName(), Double.class, 0.0));
        AtomicReference<Double> startY = new AtomicReference<Double>(((SVGAttributeHolder)this.getAttributeHolder()).getAttributeValue(CoreAttributeMapper.START_Y.getName(), Double.class, 0.0));
        AtomicReference<Double> endX = new AtomicReference<Double>(((SVGAttributeHolder)this.getAttributeHolder()).getAttributeValue(CoreAttributeMapper.END_X.getName(), Double.class, DEFAULT_END_X));
        AtomicReference<Double> endY = new AtomicReference<Double>(((SVGAttributeHolder)this.getAttributeHolder()).getAttributeValue(CoreAttributeMapper.END_Y.getName(), Double.class, 0.0));
        Enumerations.GradientUnit gradientUnit = ((SVGAttributeHolder)this.getAttributeHolder()).getAttributeValue(CoreAttributeMapper.GRADIENT_UNITS.getName(), Enumerations.GradientUnit.class, Enumerations.GradientUnit.OBJECT_BOUNDING_BOX);
        if (gradientUnit == Enumerations.GradientUnit.USER_SPACE_ON_USE) {
            if (shape == null) {
                throw new SVGException(SVGException.Reason.MISSING_ELEMENT, "Can not create linear gradient when user space is defined but the requesting shape is missing.");
            }
            this.adjustPosition(startX, startY, endX, endY, shape);
        }
        return new LinearGradient(startX.get().doubleValue(), startY.get().doubleValue(), endX.get().doubleValue(), endY.get().doubleValue(), true, ((SVGAttributeHolder)this.getAttributeHolder()).getAttributeValue(CoreAttributeMapper.SPREAD_METHOD.getName(), CycleMethod.class, SVGAttributeTypeCycleMethod.DEFAULT_VALUE), stops);
    }

    private void adjustPosition(AtomicReference<Double> startX, AtomicReference<Double> startY, AtomicReference<Double> endX, AtomicReference<Double> endY, SVGShapeBase<?> shape) throws SVGException {
        SVGAttributeTypeRectangle.SVGTypeRectangle boundingBox = shape.createBoundingBox();
        Double width = (Double)boundingBox.getMaxX().getValue() - (Double)boundingBox.getMinX().getValue();
        Double height = (Double)boundingBox.getMaxY().getValue() - (Double)boundingBox.getMinY().getValue();
        startX.set(Math.abs((Double)boundingBox.getMinX().getValue() - startX.get()) / width);
        startY.set(Math.abs((Double)boundingBox.getMinY().getValue() - startY.get()) / height);
        endX.set(Math.abs((Double)boundingBox.getMinX().getValue() - endX.get()) / width);
        endY.set(Math.abs((Double)boundingBox.getMinY().getValue() - endY.get()) / height);
    }
}

