/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.core.elements;

import de.saxsys.svgfx.core.SVGDocumentDataProvider;
import de.saxsys.svgfx.core.SVGException;
import de.saxsys.svgfx.core.attributes.XLinkAttributeMapper;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeHolder;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeTypeString;
import de.saxsys.svgfx.core.css.StyleSupplier;
import de.saxsys.svgfx.core.elements.SVGElementBase;
import de.saxsys.svgfx.core.elements.SVGShapeBase;
import de.saxsys.svgfx.core.elements.SVGStop;
import de.saxsys.svgfx.core.utils.SVGUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class SVGGradientBase<TPaint extends Paint>
extends SVGElementBase<TPaint> {
    protected SVGGradientBase(String name, Attributes attributes, SVGElementBase<?> parent, SVGDocumentDataProvider dataProvider) throws IllegalArgumentException {
        super(name, attributes, parent, dataProvider);
    }

    public final List<Stop> getStops() throws SVGException {
        Optional<SVGAttributeTypeString> link;
        ArrayList<Stop> stops = new ArrayList<Stop>(0);
        this.fillStopsOrFail(stops, this.getUnmodifiableChildren());
        if (stops.isEmpty() && (link = ((SVGAttributeHolder)this.getAttributeHolder()).getAttribute(XLinkAttributeMapper.XLINK_HREF.getName(), SVGAttributeTypeString.class)).isPresent()) {
            this.fillStopsOrFail(stops, SVGUtil.resolveIRI((String)link.get().getValue(), (SVGDocumentDataProvider)this.getDocumentDataProvider(), SVGElementBase.class).getUnmodifiableChildren());
        }
        return stops;
    }

    @Override
    public boolean rememberElement() {
        return true;
    }

    @Override
    public void startProcessing() throws SAXException {
    }

    @Override
    public void processCharacterData(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void endProcessing() throws SAXException {
        try {
            this.storeElementInDocumentDataProvider();
        }
        catch (SVGException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public boolean canConsumeResult() {
        return false;
    }

    @Override
    protected final void initializeResult(TPaint paint, StyleSupplier styleSupplier) throws SVGException {
    }

    private void fillStopsOrFail(List<Stop> stops, List<SVGElementBase<?>> children) throws SVGException {
        for (SVGElementBase<?> child : children) {
            if (!(child instanceof SVGStop)) continue;
            try {
                stops.add((Stop)((SVGStop)child).getResult());
            }
            catch (SAXException e) {
                throw new SVGException(SVGException.Reason.FAILED_TO_GET_RESULT, String.format("Could not create result for stop: %s", child));
            }
        }
    }

    public abstract TPaint createResult(SVGShapeBase<?> var1) throws SVGException;
}

