/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.core.elements;

import de.saxsys.svgfx.core.SVGDocumentDataProvider;
import de.saxsys.svgfx.core.SVGException;
import de.saxsys.svgfx.core.attributes.CoreAttributeMapper;
import de.saxsys.svgfx.core.attributes.PresentationAttributeMapper;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeHolder;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeType;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeTypeString;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeTypeTransform;
import de.saxsys.svgfx.core.css.SVGCssStyle;
import de.saxsys.svgfx.core.css.StyleSupplier;
import de.saxsys.svgfx.core.elements.SVGClipPath;
import de.saxsys.svgfx.core.elements.SVGDefinitions;
import de.saxsys.svgfx.core.utils.SVGUtil;
import de.saxsys.svgfx.core.utils.StringUtil;
import de.saxsys.svgfx.css.definitions.Constants;
import de.saxsys.svgfx.xml.core.ElementBase;
import java.util.Map;
import java.util.Optional;
import javafx.scene.Node;
import javafx.scene.transform.Transform;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class SVGElementBase<TResult>
extends ElementBase<SVGAttributeType, SVGAttributeHolder, SVGDocumentDataProvider, TResult, SVGElementBase<?>, SVGElementBase<?>> {
    private TResult result;

    protected SVGElementBase(String name, Attributes attributes, SVGElementBase<?> parent, SVGDocumentDataProvider dataProvider) throws IllegalArgumentException {
        super(name, attributes, parent, dataProvider, new SVGAttributeHolder(dataProvider));
    }

    @Override
    public final TResult getResult() throws SAXException {
        if (this.result == null) {
            try {
                this.result = this.createAndInitializeResult(this::getStyle);
            }
            catch (SVGException e) {
                throw new SAXException(e);
            }
        }
        return this.result;
    }

    public final TResult createAndInitializeResult(StyleSupplier styleSupplier) throws SVGException {
        TResult result = this.createResult(styleSupplier);
        this.initializeResult(result, styleSupplier);
        return result;
    }

    public final SVGCssStyle getStyle() throws SVGException {
        return this.getStyleAndResolveInheritance(this.getParent() != null ? ((SVGElementBase)this.getParent()).getStyle() : new SVGCssStyle((SVGDocumentDataProvider)this.getDocumentDataProvider()));
    }

    public final SVGCssStyle getStyleAndResolveInheritance(SVGCssStyle otherStyle) throws SVGException {
        SVGCssStyle style = this.getCombinedStyle();
        this.combineStylesAndResolveInheritance(style, otherStyle);
        this.cleanStyleBeforeUsing(style);
        return style;
    }

    protected final Transform getTransformation() throws SVGException {
        Optional<SVGAttributeTypeTransform> transform = ((SVGAttributeHolder)this.getAttributeHolder()).getAttribute(CoreAttributeMapper.TRANSFORM.getName(), SVGAttributeTypeTransform.class);
        if (transform.isPresent()) {
            return (Transform)transform.get().getValue();
        }
        return null;
    }

    protected final Node getClipPath(StyleSupplier styleSupplier) throws SVGException {
        Optional<SVGAttributeTypeString> referenceIRI = ((SVGAttributeHolder)this.getStyle().getAttributeHolder()).getAttribute(PresentationAttributeMapper.CLIP_PATH.getName(), SVGAttributeTypeString.class);
        if (referenceIRI.isPresent() && StringUtil.isNotNullOrEmpty((String)referenceIRI.get().getValue())) {
            return (Node)SVGUtil.resolveIRI((String)referenceIRI.get().getValue(), (SVGDocumentDataProvider)this.getDocumentDataProvider(), SVGClipPath.class).createAndInitializeResult(styleSupplier);
        }
        return null;
    }

    protected final void storeElementInDocumentDataProvider() throws SVGException {
        Optional<SVGAttributeTypeString> id;
        if (this.getParent() instanceof SVGDefinitions && (id = ((SVGAttributeHolder)this.getAttributeHolder()).getAttribute(CoreAttributeMapper.ID.getName(), SVGAttributeTypeString.class)).isPresent()) {
            ((SVGDocumentDataProvider)this.getDocumentDataProvider()).storeData((String)id.get().getValue(), this);
        }
    }

    private void cleanStyleBeforeUsing(SVGCssStyle style) throws SVGException {
        Optional<SVGAttributeTypeString> id = ((SVGAttributeHolder)this.getAttributeHolder()).getAttribute(CoreAttributeMapper.ID.getName(), SVGAttributeTypeString.class);
        if (!id.isPresent()) {
            return;
        }
        Optional<SVGAttributeTypeString> clipPath = ((SVGAttributeHolder)style.getAttributeHolder()).getAttribute(PresentationAttributeMapper.CLIP_PATH.getName(), SVGAttributeTypeString.class);
        if (!clipPath.isPresent()) {
            return;
        }
        String clipPathReference = SVGUtil.stripIRIIdentifiers((String)clipPath.get().getValue());
        if (StringUtil.isNotNullOrEmpty(clipPathReference) && clipPathReference.equals(id.get().getValue())) {
            style.getProperties().remove(PresentationAttributeMapper.CLIP_PATH.getName());
        }
    }

    private SVGCssStyle getCombinedStyle() throws SVGException {
        SVGCssStyle referencedStyle;
        SVGCssStyle style = this.getPresentationCssStyle();
        SVGCssStyle ownStyle = this.getOwnStyle();
        if (ownStyle != null) {
            if (style == null) {
                style = ownStyle;
            } else {
                style.combineWithStyle(ownStyle);
            }
        }
        if ((referencedStyle = this.getReferencedStyle()) != null) {
            if (style == null) {
                style = referencedStyle;
            } else {
                style.combineWithStyle(referencedStyle);
            }
        }
        if (style == null) {
            style = new SVGCssStyle((SVGDocumentDataProvider)this.getDocumentDataProvider());
        }
        return style;
    }

    private SVGCssStyle getOwnStyle() throws SVGException {
        Optional<SVGAttributeTypeString> style = ((SVGAttributeHolder)this.getAttributeHolder()).getAttribute(CoreAttributeMapper.STYLE.getName(), SVGAttributeTypeString.class);
        if (style.isPresent()) {
            String attribute = (String)style.get().getValue();
            SVGCssStyle ownStyle = new SVGCssStyle((SVGDocumentDataProvider)this.getDocumentDataProvider());
            try {
                ownStyle.parseCssText(String.format("ownStyle%s%s%s%s", Character.valueOf('{'), attribute, attribute.endsWith(Constants.PROPERTY_END_STRING) ? "" : Character.valueOf(';'), Character.valueOf('}')));
            }
            catch (IllegalArgumentException e) {
                throw new SVGException(SVGException.Reason.INVALID_CSS_STYLE, (Throwable)e);
            }
            return ownStyle;
        }
        return null;
    }

    private SVGCssStyle getReferencedStyle() throws SVGException {
        Optional<SVGAttributeTypeString> className = ((SVGAttributeHolder)this.getAttributeHolder()).getAttribute(CoreAttributeMapper.CLASS.getName(), SVGAttributeTypeString.class);
        if (className.isPresent()) {
            String reference = (String)className.get().getValue();
            return ((SVGDocumentDataProvider)this.getDocumentDataProvider()).getUnmodifiableStyles().stream().filter(data -> data.getName().endsWith(reference)).findFirst().orElseThrow(() -> new SVGException(SVGException.Reason.MISSING_STYLE, String.format("Given style reference %s was not found", reference)));
        }
        return null;
    }

    private SVGCssStyle getPresentationCssStyle() throws SVGException {
        SVGCssStyle result = null;
        StringBuilder cssText = new StringBuilder();
        for (PresentationAttributeMapper attributeMapper : PresentationAttributeMapper.VALUES) {
            ((SVGAttributeHolder)this.getAttributeHolder()).getAttribute(attributeMapper.getName()).ifPresent(attribute -> {
                String data = attribute.getText();
                if (StringUtil.isNotNullOrEmpty(data)) {
                    if (cssText.length() == 0) {
                        cssText.append("presentationStyle{");
                    }
                    cssText.append(String.format("%s%s%s%s", attributeMapper.getName(), Character.valueOf(':'), data, Character.valueOf(';')));
                }
            });
        }
        if (cssText.length() > 0) {
            cssText.append('}');
            result = new SVGCssStyle((SVGDocumentDataProvider)this.getDocumentDataProvider());
            try {
                result.parseCssText(cssText.toString());
            }
            catch (Exception e) {
                throw new SVGException(SVGException.Reason.INVALID_CSS_STYLE, (Throwable)e);
            }
        }
        return result;
    }

    private void combineStylesAndResolveInheritance(SVGCssStyle style, SVGCssStyle otherStyle) throws SVGException {
        if (style == null) {
            throw new SVGException(SVGException.Reason.NULL_ARGUMENT, "Given style must not be null");
        }
        if (otherStyle == null) {
            throw new SVGException(SVGException.Reason.NULL_ARGUMENT, "Given otherStyle must not be null");
        }
        style.combineWithStyle(otherStyle);
        for (Map.Entry property : style.getProperties().entrySet()) {
            if (!((SVGAttributeType)property.getValue()).getIsInherited()) continue;
            Optional otherProperty = ((SVGAttributeHolder)otherStyle.getAttributeHolder()).getAttribute(property.getKey());
            if (otherProperty.isPresent()) {
                ((SVGAttributeType)property.getValue()).setText(((SVGAttributeType)otherProperty.get()).getText());
                continue;
            }
            ((SVGAttributeType)property.getValue()).useDefaultValue();
        }
    }

    protected abstract TResult createResult(StyleSupplier var1) throws SVGException;

    protected abstract void initializeResult(TResult var1, StyleSupplier var2) throws SVGException;
}

