/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.core.attributes.type;

import de.saxsys.svgfx.core.SVGDocumentDataProvider;
import de.saxsys.svgfx.core.SVGException;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeType;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeTypeLength;
import de.saxsys.svgfx.core.definitions.Constants;
import de.saxsys.svgfx.core.utils.StringUtil;
import java.util.Arrays;
import java.util.List;
import javafx.util.Pair;

public class SVGAttributeTypeRectangle
extends SVGAttributeType<SVGTypeRectangle, Void> {
    public static final SVGTypeRectangle DEFAULT_VALUE = null;

    public SVGAttributeTypeRectangle(SVGDocumentDataProvider dataProvider) {
        super(DEFAULT_VALUE, dataProvider);
    }

    @Override
    protected Pair<SVGTypeRectangle, Void> getValueAndUnit(String text) throws SVGException {
        List<String> pointSplit = StringUtil.splitByDelimiters(text, Arrays.asList(Character.valueOf(Constants.POINTS_DELIMITER), Character.valueOf(Constants.POSITION_DELIMITER)));
        if (pointSplit.size() != 4) {
            throw new SVGException(SVGException.Reason.INVALID_RECTANGLE_FORMAT, String.format("%s does not provide minX, minY, maxX and maxY", text));
        }
        SVGTypeRectangle point = new SVGTypeRectangle(this.getDocumentDataProvider());
        point.getMinX().setText(pointSplit.get(0).trim());
        point.getMinY().setText(pointSplit.get(1).trim());
        point.getMaxX().setText(pointSplit.get(2).trim());
        point.getMaxY().setText(pointSplit.get(3).trim());
        return new Pair((Object)point, null);
    }

    public static class SVGTypeRectangle {
        private final SVGAttributeTypeLength minX;
        private final SVGAttributeTypeLength minY;
        private final SVGAttributeTypeLength maxX;
        private final SVGAttributeTypeLength maxY;

        public SVGTypeRectangle(SVGDocumentDataProvider dataProvider) {
            this.minX = new SVGAttributeTypeLength(dataProvider);
            this.minY = new SVGAttributeTypeLength(dataProvider);
            this.maxX = new SVGAttributeTypeLength(dataProvider);
            this.maxY = new SVGAttributeTypeLength(dataProvider);
        }

        public final SVGAttributeTypeLength getMinX() {
            return this.minX;
        }

        public final SVGAttributeTypeLength getMinY() {
            return this.minY;
        }

        public final SVGAttributeTypeLength getMaxX() {
            return this.maxX;
        }

        public final SVGAttributeTypeLength getMaxY() {
            return this.maxY;
        }
    }
}

