/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.core.attributes.type;

import de.saxsys.svgfx.core.SVGDocumentDataProvider;
import de.saxsys.svgfx.core.SVGException;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeType;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeTypePoint;
import de.saxsys.svgfx.core.definitions.Constants;
import de.saxsys.svgfx.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.util.Pair;

public class SVGAttributeTypePoints
extends SVGAttributeType<List<SVGAttributeTypePoint>, Void> {
    public static final List<SVGAttributeTypePoint> DEFAULT_VALUE = new ArrayList<SVGAttributeTypePoint>();

    public SVGAttributeTypePoints(SVGDocumentDataProvider dataProvider) {
        super(DEFAULT_VALUE, dataProvider);
    }

    @Override
    protected Pair<List<SVGAttributeTypePoint>, Void> getValueAndUnit(String text) throws SVGException {
        ArrayList<SVGAttributeTypePoint> actualPoints = new ArrayList<SVGAttributeTypePoint>();
        if (StringUtil.isNotNullOrEmpty(text)) {
            List<String> values = StringUtil.splitByDelimiters(text, Collections.singletonList(Character.valueOf(Constants.POINTS_DELIMITER)), (currentData, index) -> {
                boolean containsDelimiter = currentData.contains(Constants.POSITION_DELIMITER_STRING);
                if (containsDelimiter && currentData.charAt(currentData.length() - 1) != Constants.POSITION_DELIMITER) {
                    return true;
                }
                if (index == text.length() - 1 || text.charAt(index + 1) != Constants.POINTS_DELIMITER) {
                    throw new SVGException(SVGException.Reason.INVALID_POINT_FORMAT, "Invalid points format");
                }
                return false;
            });
            for (String pointsSplit : values) {
                SVGAttributeTypePoint actualPoint = new SVGAttributeTypePoint(this.getDocumentDataProvider());
                actualPoint.setText(pointsSplit);
                actualPoints.add(actualPoint);
            }
        }
        return new Pair(actualPoints, null);
    }
}

