/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.core.attributes.type;

import de.saxsys.svgfx.core.SVGDocumentDataProvider;
import de.saxsys.svgfx.core.SVGException;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeType;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeTypeLength;
import de.saxsys.svgfx.core.definitions.Constants;
import javafx.util.Pair;

public class SVGAttributeTypePoint
extends SVGAttributeType<SVGTypePoint, Void> {
    public static final SVGTypePoint DEFAULT_VALUE = null;

    public SVGAttributeTypePoint(SVGDocumentDataProvider dataProvider) {
        super(DEFAULT_VALUE, dataProvider);
    }

    @Override
    protected Pair<SVGTypePoint, Void> getValueAndUnit(String text) throws SVGException {
        String[] pointSplit = text.split(Constants.POSITION_DELIMITER_STRING);
        if (pointSplit.length != 2) {
            throw new SVGException(SVGException.Reason.INVALID_POINT_FORMAT, "point does not provide x and y position");
        }
        SVGTypePoint point = new SVGTypePoint(this.getDocumentDataProvider());
        point.getX().setText(pointSplit[0].trim());
        point.getY().setText(pointSplit[1].trim());
        return new Pair((Object)point, null);
    }

    public static class SVGTypePoint {
        private final SVGAttributeTypeLength x;
        private final SVGAttributeTypeLength y;

        public SVGTypePoint(SVGDocumentDataProvider dataProvider) {
            this.x = new SVGAttributeTypeLength(dataProvider);
            this.y = new SVGAttributeTypeLength(dataProvider);
        }

        public final SVGAttributeTypeLength getX() {
            return this.x;
        }

        public final SVGAttributeTypeLength getY() {
            return this.y;
        }
    }
}

