/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.core.attributes.type;

import de.saxsys.svgfx.core.SVGDocumentDataProvider;
import de.saxsys.svgfx.core.SVGException;
import de.saxsys.svgfx.core.attributes.type.SVGAttributeType;
import de.saxsys.svgfx.core.definitions.Enumerations;
import javafx.scene.shape.FillRule;
import javafx.util.Pair;

public class SVGAttributeTypeFillRule
extends SVGAttributeType<FillRule, Void> {
    public static final FillRule DEFAULT_VALUE = FillRule.EVEN_ODD;

    public SVGAttributeTypeFillRule(SVGDocumentDataProvider dataProvider) {
        super(DEFAULT_VALUE, dataProvider);
    }

    @Override
    protected Pair<FillRule, Void> getValueAndUnit(String cssText) throws SVGException {
        FillRule result = null;
        for (Enumerations.FillRuleMapping mapping : Enumerations.FillRuleMapping.values()) {
            if (!mapping.getName().equals(cssText)) continue;
            result = mapping.getRule();
            break;
        }
        if (result == null) {
            throw new SVGException(SVGException.Reason.INVALID_FILL_RULE, String.format("Given %s can not be parsed into a fill rule", cssText));
        }
        return new Pair(result, null);
    }
}

